#ifndef __RNG_H__
#define __RNG_H__

#include <gsl/gsl_rng.h>
#include <ctime>
#include<iostream>
#include <cstring>
#include <fstream>
#include <vector>

#define ABS(x) ((x) >= 0 ? (x) : -(x))
#define mymin(a,b) ((a) <= (b) ? (a) : (b))
#define mymax(a,b) ((a) >= (b) ? (a) : (b))
#define OVERFLO 1e100
#define UNDERFLO 1e-100


namespace fines
{

  gsl_rng * makerng(bool fast=false);
  unsigned long seedrng(gsl_rng * rng,unsigned long seed=0,int verbose=1);
  int saverng(gsl_rng * rng,std::string fname);
  int loadrng(gsl_rng * rng,std::string fname);
  void freerng(gsl_rng * rng);
  
  double RandomReal(gsl_rng * rng,double low, double high);
  int RandomInteger(gsl_rng * rng,int low, int high);
  double rnd(gsl_rng * rng);
  double RGamma(gsl_rng * rng,double n,double lambda);
  void RDirichlet(gsl_rng * rng,const std::vector<double> * a, std::vector<double>  * b);
  long RPoisson(gsl_rng * rng,double mu);
  double RExpon(gsl_rng * rng,double av);
  double RNormal(gsl_rng * rng,double mu,double sd) ;
  double sexpo(gsl_rng * rng);
  double snorm(gsl_rng * rng);
  double genexp(gsl_rng * rng,double av);   
  long ignpoi(gsl_rng * rng,double mean);  
  long ignuin(gsl_rng * rng,int low, int high);   
  double genunf(gsl_rng * rng,double low, double high);   
  long   Binomial(gsl_rng * rng,int n, double p);
  long   Binomial1(gsl_rng * rng,int n, double p);
  void LogRDirichlet (gsl_rng * rng,const double *a, const int k, double *b,double *c);

  double BinoProb(int n, double p,int i);
  double fsign(double num, double sign );

} // end namespace fines
#endif // __RNG_H__
