#ifndef VISGRID_H
#define VISGRID_H

#include <wx/wx.h>
#include <float.h>
#include <vector>
#include <string>

using namespace std;

class VisGrid
{
public:
    VisGrid(long n, long width,long height);
    void setGrid(long n, long width,long height, int nsuper=-1,int supersize=-1);
    void setGrid(long n,vector<double> widths, long width,long height, int nsuper=-1,int supersize=-1);
    inline vector <int> *getGridx(){
	return(&gridx);
    }
    inline vector <int> *getGridy(){
	return(&gridy);
    }
    inline long getMaxX(){
      if(gridx.size()>0) return(gridx.back());
      return(1);
    }
    inline long getMaxY(){
      if(gridy.size()>0) return(gridy.back());
      return(1);
    }
    inline double getFontSize(){
      return(fontsize);
    }
    inline void setFontSize(double val){
      fontsize=val;
    }
    inline void setUsePopLabels(bool val){
      usePopLabels=val;
    }
    inline bool getUsePopLabels(){
      return(usePopLabels);
    }
    inline bool getUseClassificationLabels(){
      return(useClassificationLabels);
    }
    inline int getClassificationLabelSize(){
      return(classificationLabelSize);
    }
    inline void  setPerpPopLabels(bool val){
      perpPopLabels=val;
    }
    inline void setUseClassificationLabels(bool val){
      useClassificationLabels=val;
    }
    inline void setClassificationLabelSize(int val){
      classificationLabelSize=val;
    }
    inline bool getPerpPopLabels(){
      return(perpPopLabels);
    }
    inline int getLabelGap(){
      return(labelgap);
    }
    inline bool contsEnabled(bool checky=false){
      if(checky){return(contsenabledy);
      }else return(contsenabledx);
    }
    inline vector<int> getRect(unsigned int i, unsigned int j){
      vector<int> ret(4,0);
      ret[0]=gridx[i];
      ret[1]=gridy[j];
      ret[2]=gridx[i+1]-gridx[i];
      ret[3]=gridy[j+1]-gridy[j];
      return(ret);
    }///* Gets the rectangle in (topleft,topright,width,height) format using the grid
    inline int getTreeWidth(){return(treewidth);};
    inline void setTreeWidth(int val){treewidth=val;};
    inline int getGrad(){
      return(scalecount);
    };
    inline int getScaleSkip(){
      return(scaleskip);
    };
    inline int getScaleBarSize(){
      return(scalesize);
    };
    inline int getScaleTextSize(){
      return(scaletextsize);
    };    
    inline void setScaleTextSize(int val){
      scaletextsize=val;
    };
    inline void setScaleBarSize(int val){
      scalesize=val;
    };
    inline double getScale(){
      return(scalemax);
    };
    inline void setScale(double val){
      scalemax=val;
    };    
    inline void setLabelGap(int val){
      labelgap=val;
    }
    inline double getScaleMin(){
      return(scalemin);
    };
    inline void setScaleMin(double val){
      scalemin=val;
    };    
    wxString getScaleFormat(){
      return(scaleformat);
    };
    inline void setScaleFormat(wxString val){
      scaleformat=val;
    };
    inline void setData2(bool val){
      usedata2=val;
    }   
    inline bool getData2(){
      return(usedata2);
    }
    inline int getNeff(){
      return(nsuper*supersize + (gridy.size()-nsuper));
    }
    inline wxColour getLabelCol(int index){
      //return(getLabelColUnordered(index));
      if(index<0 || index>= (int)labelCol.size() ||laborder==NULL) return wxColour(0,0,0);
      if(index>= (int)laborder->size()) return (labelCol[index]);
      return(labelCol[laborder->at(index)]);
    }
    inline vector<wxColour> getLabelColUnordered(){
      return(labelCol);
    }
    inline void setLabelCol(vector<int> *neworder,vector<wxColour> tcols){
      labelCol=tcols;
      laborder=neworder;
    }
    inline bool getUseContinentCols(){
      return(contsenabledx);
    }
    inline bool getUseContinentRows(){
      return(contsenabledy);
    }
    inline void setUseContinentCols(bool val){
      contsenabledx=val;
    }
    inline void setUseContinentRows(bool val){
      contsenabledy=val;
    }
    double convertLefting(double lefting0,bool isylab);///<Converts a lefting value if continents are disabled
    inline int getDatavis(){return(datavis);}
    inline void setDatavis(int val){datavis=val;}    
    inline int getDatavis2(){return(datavis2);}
    inline void setDatavis2(int val){datavis2=val;}    
    inline void setPopScale(double val){popscale=val;}
    inline double getPopScale(){return(popscale);}
  protected:
    wxString scaleformat;
    double scalemin;
    double scalemax;
    int scalesize;
    int scalecount;
    int scaleskip;
    int scaletextsize;
    int scaleprecision;
    bool usedata2;
    double fontsize;
    int treewidth;
    long n;
    bool usePopLabels;
    bool perpPopLabels;
    bool useClassificationLabels;
    int nsuper;
    int supersize;
    int classificationLabelSize;
    int labelgap;
    bool contsenabledx,contsenabledy;
    int datavis;
    int datavis2;
    vector <int> gridx;
    vector <int> gridy;
    vector<int> * laborder;
    vector <wxColour> labelCol;
    double popscale;
};

#endif
