
#ifndef LABELINDS_H
#define LABELINDS_H

#include <wx/wx.h>
#include <wx/grid.h>
#include <wx/menu.h>
#include <wx/string.h>
#include <wx/image.h>
#include <wx/filename.h>
#include <wx/dc.h>
#include <wx/combobox.h>
#include <wx/arrstr.h>
#include <wx/colordlg.h>
#include <wx/cmndata.h>

#include "inputdata.h"
#include "wholedisplay.h"

#define LABELINDS_ID_OKBUTTON 1
#define LABELINDS_ID_CANCELBUTTON 2
#define LABELINDS_ID_INFERBUTTON 3
#define LABELINDS_ID_NEWBUTTON 4

using namespace std;

class LabelWindow : public wxFrame
{
  public:
  LabelWindow(InputData *inputdata,FineDisplay *finedisplay,wxPanel *parent, int id,const wxString& title);
  void OnOkButton(wxCommandEvent & event);
  void OnSize(wxSizeEvent & event);
  void OnInferButton(wxCommandEvent & event);
  void OnNewButton(wxCommandEvent & event);
  inline void OnCancelButton(wxCommandEvent & event){
    Close(true);
  };
  void OnGridCellClick(wxGridEvent &event);
  void OnGridCellChanged(wxGridEvent &event);
  void UpdateOnColourChange(int row,wxColour newcolour);
  void UpdateOnLabelEdit(int row);
  protected:

  wxPanel *toppanel;
  wxPanel *parent;
  wxGrid * namegrid;
  wxScrolledWindow * scroller;
  wxButton *okButton;
  wxButton *cancelButton;
  wxButton *inferButton;
  wxButton *newButton;
  wxFlexGridSizer *vsizer;
  wxFlexGridSizer *hsizer;
  InputData *inputdata;
  FineDisplay *finedisplay;

};

#endif
