
#include "visgrid.h"

VisGrid::VisGrid(long n, long width,long height)
{
  datavis=101;//FSGUI_SHOW_COPYMATRIX;
  datavis2=100;//FSGUI_SHOW_NONE;
  treewidth=1;
  fontsize=-0.9;
  usePopLabels=false;
  perpPopLabels=false;
  useClassificationLabels=false;
  scalecount=200;
  scaleskip=10;
  scalesize=10;
  scaletextsize=10;
  scaleprecision=2;
  supersize=1;
  contsenabledx=true;
  contsenabledy=true;
  scalemin=-1.0;
  scalemax=-1.0;
  labelgap=10;
  popscale=1.0;
  scaleformat=wxT("%0.1f");
  setGrid(n,width,height,0,1);
  usedata2=false;
  laborder=NULL;
}

void VisGrid::setGrid(long n, long width,long height, int nsuper,int supersize)
{
  //cout<<"setgrid with n="<<n<<endl;
    if(this->n!=n) {
      gridx=vector<int>(n+1,0);
      gridy=vector<int>(n+1,0);
      gridx[0]=0;
      gridy[0]=0;        
    }
    if(nsuper>=0)this->nsuper=nsuper;
    if(supersize>=0)this->supersize=supersize;
    this->n=n;
    int gridmaxX=gridx.size() + (this->supersize*contsenabledx-1)*this->nsuper; // ordinary are 1, super are supersize      
    int gridmaxY=gridy.size() + (this->supersize*contsenabledy-1)*this->nsuper; // ordinary are 1, super are supersize      
    for(unsigned int c1=1;c1<gridx.size();c1++){
      if((int)c1>this->nsuper) gridx[c1]= (c1+this->nsuper*(this->supersize*contsenabledx-1))*  width/(double)(gridmaxX-0.5);
      else  gridx[c1]= c1*(this->supersize*contsenabledx)*width/(double)(gridmaxX-0.5);
    }
    for(unsigned int c1=1;c1<gridy.size();c1++){
      if((int)c1>this->nsuper) gridy[c1]= (c1+this->nsuper*(this->supersize*contsenabledy-1))*  height/(double)(gridmaxY-0.5);
      else  gridy[c1]= c1*(this->supersize*contsenabledy)*height/(double)(gridmaxY-0.5);
    }
    //cout<<"Done setgrid"<<endl;
//    cout<<"gridx[0]="<<gridx[0]<<" gridx[99]="<<gridx[99]<<" gridy[0]="<<gridy[0]<<" gridy[99]="<<gridy[99]<<endl;
//    cout<<" width="<<width<<" gridmaxX="<<gridmaxX<<" height="<<height<<" gridmaxY="<< gridmaxY<<endl;
    /*
        if(this->n<n) {
      gridx=vector<int>(n+1,0);
      gridy=vector<int>(n+1,0);
    }
    this->n=n;
    gridx[0]=0;
    gridy[0]=0;
    int gridmax=gridx.size() + (supersize-1)*nsuper; // ordinary are 1, super are supersize
    gridmax=gridx.size() ;
    for(unsigned int c1=1;c1<gridx.size();c1++){
      if(c1>nsuper) gridx[c1]= c1* width/(double)(gridmax-0.5);
      else  gridx[c1]= gridx[c1-1] + supersize*width/(double)(gridmax-0.5);
    }
    for(unsigned int c1=1;c1<gridy.size();c1++){
      if(c1>nsuper) gridy[c1]= c1*width/(double)(gridmax-0.5);
      else  gridy[c1]= gridy[c1-1] + supersize*width/(double)(gridmax-0.5);
    }
     */
}

void VisGrid::setGrid(long n,vector<double> widths, long width,long height, int nsuper,int supersize)
{  
  if(n!=(long)widths.size()) throw(string("Invalid sizes passed to setGrid!"));
  double totalwidths=0;
  for(unsigned int c1=0;c1<widths.size();c1++)totalwidths+=widths[c1];
  //cout<<"setgrid with n="<<n<<endl;
    if(this->n!=n) {
      gridx=vector<int>(n+1,0);
      gridy=vector<int>(n+1,0);
      gridx[0]=0;
      gridy[0]=0;        
    }
    if(nsuper>=0)this->nsuper=nsuper;
    if(supersize>=0)this->supersize=supersize;
    this->n=n;
    double gridmaxX=(this->supersize*contsenabledx-1)*this->nsuper + totalwidths;
    double gridmaxY=(this->supersize*contsenabledy-1)*this->nsuper + totalwidths;
    
//    cout<<"Gridmax PRE="<<gridmaxX<<","<<gridmaxY<<endl;
//      cout<<"gridx["<<0<<"]="<<gridx[0]<<endl;
    for(unsigned int c1=1;c1<gridx.size();c1++){
      if((int)c1>this->nsuper) gridx[c1]= gridx[c1-1]+widths[c1-1]*  (double)width/(double)(gridmaxX-0.0);
      else  gridx[c1]= c1*(this->supersize*contsenabledx)*(double)width/(double)(gridmaxX-0.0);
//      cout<<"gridx["<<c1<<"]="<<gridx[c1]<<endl;
    }
//      cout<<"gridy["<<0<<"]="<<gridy[0]<<endl;
    for(unsigned int c1=1;c1<gridy.size();c1++){
      if((int)c1>this->nsuper) gridy[c1]= gridy[c1-1]+widths[c1-1]*  (double)height/(double)(gridmaxY-0.0);
      else  gridy[c1]= c1*(this->supersize*contsenabledy)*(double)height/(double)(gridmaxY-0.0);
//      cout<<"gridy["<<c1<<"]="<<gridy[c1]<<endl;
    }
//    cout<<"Gridmax="<<gridx.back()<<","<<gridy.back()<<endl;
//    gridx.back()=width - 5;
//    gridy.back()=height - 5;
//    cout<<"Done setgrid"<<endl;  
}
  
double VisGrid::convertLefting(double lefting0,bool isylab)
{
  if(isylab && contsenabledx) return(lefting0);
  if(!isylab && contsenabledy) return(lefting0);
  // if we get to here, then continents are set to effective size 0
  double x0=((double)nsuper*supersize)/(double)(nsuper*supersize+gridy.size()-nsuper);
  double slope=1.0/(1.0-x0);
  double intercept=-x0*slope;
  return(slope*lefting0 + intercept);
}

