#include "showlabels.h"

//#define DEBUGPRINT(x) cout<<x<<endl
#define DEBUGPRINT(x) 

ShowLabels::ShowLabels(InputData *indat,VisGrid *visgrid,bool isylab,wxPanel *parent, int id)
      : wxVirtualPanel(parent, id, wxDefaultPosition, wxSize(-1, -1), wxBORDER_NONE)
{
  m_parent = parent;
  this->isylab=isylab;
  this->dat=indat;
  this->visgrid=visgrid;
  setSize(50);  
  setGrid();
  Connect(wxEVT_PAINT, wxPaintEventHandler(ShowLabels::OnPaint));
  Connect(wxEVT_SIZE, wxSizeEventHandler(ShowLabels::OnSize));
  Connect( -1, wxEVT_LEFT_DOWN, wxMouseEventHandler(ShowLabels::OnLeftDown) );  
}

void ShowLabels::OnPaint(wxPaintEvent& event)
{
  wxPaintDC dc(this);
  show(dc);
}

void ShowLabels::show(wxDC&  dc){
  DEBUGPRINT("startShowLabels");
  setGrid();
  dc.SetPen(wxPen(wxColour(255, 255,255)));
  dc.SetBrush(wxBrush(wxColour(255, 255,255)));
  wxSize size = dc.GetSize();//GetClientSize();
  if((isylab && (size.y !=getSize())) || (!isylab && (size.x !=getSize()))) setGrid();
  
  int width = size.GetWidth();
  int height= size.GetHeight();
  dc.DrawRectangle(0,0,width,height);

  wxFont font(textsize, wxFONTFAMILY_SWISS, wxNORMAL, wxNORMAL);
  wxFont font2(textsize*0.66, wxFONTFAMILY_SWISS, wxNORMAL, wxNORMAL);

  dc.SetFont(font);
  dc.SetTextForeground(wxColour(0,0,0));
  dc.SetPen(wxPen(wxColour(0,0,0)));
  dc.SetBrush(wxBrush(wxColour(0,0,0)));
 // dc.SetBackgroundMode(wxTRANSPARENT);
  int labelgap=visgrid->getLabelGap();
  if(visgrid->getUseClassificationLabels() && (visgrid->getGridx()->size()==1+textpts.size())){/// draw the classification boxes
    for(unsigned long c1=0;c1<textpts.size();c1++){
      //      int r=0;
      //      if(dat->getNumLabels() > 0) r=256 * (double)dat->getLabel(c1)/(double)dat->getNumLabels();
      //wxColour tcol=wxColour(r,0,0);
      wxColour tcol=visgrid->getLabelCol(c1);
      dc.SetPen(wxPen(tcol));
      dc.SetBrush(wxBrush(tcol));
      bool plotthis=true;
      //if(c1>=1)if(textpts[c1]==textpts[c1-1]) plotthis=false;
      //if(c1==0 && textpts[0]==textpts[1]) plotthis=false;
      if(!isylab && plotthis) {
    	int yloc1=visgrid->getGridy()->at(c1) + (visgrid->getGridy()->at(c1+1) - visgrid->getGridy()->at(c1) ) *0.1; 
	int yloc2=(visgrid->getGridy()->at(c1+1) - visgrid->getGridy()->at(c1) ) *0.8;	
	//dc.DrawLine(size.x-8,textpts[c1]-textsize*0.5, size.x,textpts[c1]-textsize*0.5);
	dc.DrawRectangle(size.x-labelgap+2,yloc1,labelgap-4,yloc2);
      }else if(isylab && plotthis) {
    	int yloc1=visgrid->getGridx()->at(c1) + (visgrid->getGridx()->at(c1+1) - visgrid->getGridx()->at(c1) ) *0.1;
	int yloc2=(visgrid->getGridx()->at(c1+1) - visgrid->getGridx()->at(c1) ) *0.8;	
	//dc.DrawLine(textpts[c1]-textsize*0.5, size.y-8,textpts[c1]-textsize*0.5,size.y);
	dc.DrawRectangle(yloc1,size.y-labelgap+2,yloc2,labelgap-4);
      }
    }    
  }
  
  dc.SetPen(wxPen(wxColour(0,0,0)));
  dc.SetBrush(wxBrush(wxColour(0,0,0)));
  
  if(visgrid->getUsePopLabels()){/// write population labels
    nodes=dat->getNodes();
    int numlinespace=0;
    if(isylab) numlinespace=visgrid->getMaxX();
    else numlinespace=visgrid->getMaxY();
    double textptson=0;
    for(long c1=0;c1<dat->getNumPops();c1++){
      //long visorder=dat->invertPopOrder(c1);
      double lefting=getLefting(nodes[dat->getPopNode(c1,true)]);
      textptson=lefting*(double) numlinespace;// +numlinespace/(double)(textpts.size()+0.5);
      DEBUGPRINT("Lefting="<<lefting<<" textptson="<<textptson);
      //if(isylab) textptson=(visgrid->getGridx()->at(c1)+visgrid->getGridx()->at(c1+1))/2;
      //else textptson=(visgrid->getGridy()->at(c1)+visgrid->getGridy()->at(c1+1))/2;
      if(lefting<0 || lefting > 1) continue;
      wxString text= dat->getPopName(c1,true);
      int swidth, sheight;
      if(dat->getDisplayLabel(dat->getPopOrder(c1))==0) continue;// don't show these ones
      GetTextExtent(text,&swidth,&sheight,NULL, NULL, &font);
      if(swidth==0 || sheight==0) continue;
      // tweak the positioning to centre the text on the population
      if(c1>=dat->getNumContinents() || !dat->getUseMod()){
	if(isylab&& !visgrid->getPerpPopLabels()) {
	  textptson-=sheight/4.0;
	  if(c1>=dat->getNumContinents())textptson+=sheight/4.0;
	}else if(!isylab&& !visgrid->getPerpPopLabels()) {
	  textptson+=sheight/4.0;
	  if(c1>=dat->getNumContinents())textptson+=sheight/4.0;
	}
      }
      if(c1<dat->getNumContinents() && !isylab)textptson+=sheight/4.0;
      wxString text2=dat->getContRangeWx(dat->getorder()->at(c1),visgrid->getDatavis(),isylab,visgrid->getScaleFormat());
    int swidth2,sheight2;
      GetTextExtent(text2,&swidth2,&sheight2,NULL, NULL, &font2);
      // plot, and add range if needed
      if(!isylab&& !visgrid->getPerpPopLabels()) {
	dc.DrawRotatedText(text, size.x - labelgap - swidth,textptson-sheight*1.0, 0);
	if(c1<dat->getNumContinents() && dat->getUseMod()){
	    dc.SetFont(font2);
	    dc.DrawRotatedText(text2, size.x - labelgap - swidth2,textptson, 0);
	    dc.SetFont(font);
	}
      }else if(isylab&& !visgrid->getPerpPopLabels()) {
	dc.DrawRotatedText(text, textptson + sheight*0.5,size.y - labelgap - swidth, 270);
	if(c1<dat->getNumContinents() && dat->getUseMod()){
	    dc.SetFont(font2);
	    dc.DrawRotatedText(text2, textptson -sheight*0.5+ sheight2*0.3,size.y - labelgap - swidth2, 270);
	    dc.SetFont(font);
	}
      }else if(!isylab&& visgrid->getPerpPopLabels()){
	dc.DrawRotatedText(text, size.x - labelgap -sheight,textptson+swidth/2.0, 90);
      }else if(isylab&& visgrid->getPerpPopLabels()) {
	dc.DrawRotatedText(text, textptson-swidth/2.0,size.y - labelgap -sheight , 0);
      }

    }
  }else{/// write individual labels
    if(visgrid->getDatavis()==FSGUI_SHOW_COPYAGMATRIXSIMPLE) return;
    
    for(unsigned long c1=0;c1<textpts.size();c1++){
      wxString text=dat->getName(dat->getorder()->at(c1));
      int swidth, sheight;
      GetTextExtent(text,&swidth,&sheight,NULL, NULL, &font);

      wxString text2=dat->getContRangeWx(dat->getorder()->at(c1),visgrid->getDatavis(),isylab,visgrid->getScaleFormat());
      int swidth2,sheight2;
      GetTextExtent(text2,&swidth2,&sheight2,NULL, NULL, &font2);
      
      bool plotthis=true;
      if(c1>=1)if(textpts[c1]==textpts[c1-1]) plotthis=false;
      if(c1==0 && textpts[0]==textpts[1]) plotthis=false;
      if(!isylab && plotthis) {
	if((long)c1<dat->getNumContinents() && dat->getUseMod()){
	    dc.DrawRotatedText(text, size.x - labelgap - swidth,textpts[c1]-textsize*1.3, 0);
	    dc.SetFont(font2);
	    dc.DrawRotatedText(text2, size.x - labelgap - swidth2,textpts[c1]-textsize*1.3+sheight - sheight2*0.3, 0);
	    dc.SetFont(font);
	}else dc.DrawRotatedText(text, size.x - labelgap - swidth,textpts[c1]-textsize*1.3, 0);
	if(!visgrid->getUseClassificationLabels()) dc.DrawLine(size.x-labelgap+2,textpts[c1]-textsize*0.5, size.x,textpts[c1]-textsize*0.5);
      }else if(isylab && plotthis) {
	if((long)c1<dat->getNumContinents() && dat->getUseMod()){
	    dc.DrawRotatedText(text, textpts[c1]+sheight*0.5,size.y - labelgap - swidth, 270);
	    dc.SetFont(font2);
	    dc.DrawRotatedText(text2, textpts[c1]+sheight*0.5-sheight+ sheight2*0.3,size.y - labelgap - swidth2, 270);
	    dc.SetFont(font);
	}else dc.DrawRotatedText(text, textpts[c1]+sheight*0.2,size.y - labelgap - swidth, 270);
	if(!visgrid->getUseClassificationLabels()) dc.DrawLine(textpts[c1]-textsize*0.5, size.y-labelgap+2,textpts[c1]-textsize*0.5,size.y);
      }

    }
  }
/// Write the true ranges if we rescaled continents
/*  dc.SetFont(font2);
  for(unsigned long c1=0;c1<textpts.size();c1++){
     if(dat->getUseMod() && (long)c1< dat->getNumContinents()) {
	wxString text=dat->getName(dat->getorder()->at(c1));
	text=dat->getContRangeWx(dat->getorder()->at(c1),visgrid->getDatavis(),isylab,visgrid->getScaleFormat());
	int swidth, sheight;
	GetTextExtent(text,&swidth,&sheight,NULL, NULL, &font);
	int swidth2,sheight2;
	GetTextExtent(text,&swidth2,&sheight2,NULL, NULL, &font2);
	if(isylab  && !visgrid->getPerpPopLabels() && textpts[c1]>0) dc.DrawRotatedText(text,  textpts[c1]-sheight*0.6,size.y - labelgap - swidth2,270);
	if(!isylab && !visgrid->getPerpPopLabels() && textpts[c1]-textsize*1.0>0) dc.DrawRotatedText(text,  size.x - labelgap - swidth2,textpts[c1]-textsize*1.0+ sheight*0.7,0);
     }
  }*/


///NOTE: On Windows, only TrueType fonts can be drawn rotated. Be aware that the stock object wxNORMAL_FONT is not TrueType.
  DEBUGPRINT("endShowLabels");
}

void ShowLabels::setGrid()
{
  int n=dat->getN();
  //  int linespace=0;
  int numlinespace=0;
  //  linespace=getSize();
  if(isylab) {
    numlinespace=visgrid->getMaxX();
  }else {
    numlinespace=visgrid->getMaxY();
  }
  if((int) textpts.size()!=n) textpts=vector<int>(n,0);
  if(textpts.size()==0) return;
  textsize=GetFontSize(numlinespace);
  if(visgrid->getDatavis()==FSGUI_SHOW_COPYAGMATRIXSIMPLE) return;
  for(unsigned int c1=0;c1<textpts.size();c1++){
    if(isylab) textpts[c1]=(visgrid->getGridx()->at(c1)+visgrid->getGridx()->at(c1+1)+numlinespace/(double)(visgrid->getNeff()+0.5))/2 ;//+numlinespace/(double)(textpts.size()+0.5);
    else textpts[c1]=(visgrid->getGridy()->at(c1)+visgrid->getGridy()->at(c1+1)+numlinespace/(double)(visgrid->getNeff()+0.5))/2;//visgrid->getGridy()->at(c1) +numlinespace/(double)(textpts.size()+0.5);
  }
  classifyboxsize=max(1,floor(numlinespace*1.0/(double)(textpts.size())));
  int longest=0;
  wxFont font(textsize, wxFONTFAMILY_SWISS, wxNORMAL, wxNORMAL);
  for(unsigned long c1=0;c1<textpts.size();c1++){
    wxString text=dat->getName(c1);
    int swidth, sheight;
    GetTextExtent(text,&swidth,&sheight,NULL, NULL, &font);
    if(swidth>longest)longest=swidth;
  }
}

int ShowLabels::GetFontSize(int numlinespace){
  if(visgrid->getFontSize()<0) return(max(1,floor(-numlinespace*visgrid->getFontSize()/(double)(textpts.size()))));
  return(max(2,visgrid->getFontSize()));
}

void ShowLabels::OnSize(wxSizeEvent& event)
{
  setGrid();
  Refresh();
}


void ShowLabels::OnLeftDown(wxMouseEvent & event)
{
  if(!visgrid->getUsePopLabels()) return;
  wxSize size = GetSize();//GetClientSize();
  if(isylab)size.x=visgrid->getMaxX();
  else size.y=visgrid->getMaxY();
  if(isylab) size.y-=10;
  else size.x-=10;
  double es=ceil(visgrid->getTreeWidth()/2);

  wxPoint pos=event.GetPosition();
  nodes=dat->getNodes();
  if(nodes.size()<1) return;
  double rootage=dat->getRoot()->getAge();
  if(isylab)rootage*=(size.y+es)/(double)(size.y-10);
  else rootage*=(size.x+es)/(double)(size.x-10);

  double mindistsq=1000000000;
  int minnode=-1;
  int x=pos.x,y=pos.y;
  for(int c1=0;c1<dat->getN();c1++){
    if(isylab){
      x= getLefting(nodes[c1])*size.x;
    }else{
      y= getLefting(nodes[c1])*size.y;
    }
    double distsq=(x-pos.x)*(x-pos.x)+(y-pos.y)*(y-pos.y);
    if(distsq<mindistsq){ mindistsq=distsq;minnode=c1;}
  }
    if(isylab){
      x= getLefting(dat->getRoot())*size.x;
    }else{
      y= getLefting(dat->getRoot())*size.y;
    }

  if(mindistsq<100){
    long innode=dat->insidePopNode(nodes[minnode]);
    if(innode>=0){
      dat->toggleDisplayLabel(innode);
    }
  }
  m_parent->Refresh();
}


double ShowLabels::getLefting(Node* node)
{
 //if(visgrid->contsEnabled(isylab))return(node->getLefting());
  return(visgrid->convertLefting(node->getLefting(),isylab));
}
