
#ifndef PCA_H
#define PCA_H

#include <wx/wx.h>
#include <wx/menu.h>
#include <wx/string.h>
#include <wx/image.h>
#include <wx/filename.h>
#include <wx/dc.h>
#include <wx/dcbuffer.h>

#include <vector>
#include <float.h>
#include <sstream>
#include <fstream>

#include "inputdata.h"
#include "../pcadata.h"

using namespace std;

#define PCAPLOT_ID_HELP 1001
#define PCAPLOT_ID_CLOSE 1002
#define PCAPLOT_ID_EXPORT 1003
#define PCAPLOT_ID_CHOICE1 1004
#define PCAPLOT_ID_EXPORTCSV 1005 
#define PCAPLOT_ID_CHOICE2 1006
#define PCAPLOT_ID_PTSIZE 1007
#define PCAPLOT_ID_LEGLOC 1008
#define PCAPLOT_ID_LEGSIZE 1009
#define PCAPLOT_ID_ALTPT 1010
#define PCAPLOT_ID_XMIN 1011
#define PCAPLOT_ID_XMAX 1012
#define PCAPLOT_ID_YMIN 1013
#define PCAPLOT_ID_YMAX 1014

class PlotSpacePCA: public wxPanel
{
  public:
    
    PlotSpacePCA(wxWindow* parent, wxWindowID id = wxID_ANY, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize, long style = wxTAB_TRAVERSAL, const wxString& name = wxT("panel"));
    inline void setXName(wxString name){
      nameX=name;
    }
    inline void setYName(wxString name){
      nameY=name;
    }
    inline void setXData(vector<double> *d){
      dataX.clear();
      for(unsigned int c1=0;c1<d->size();c1++) dataX.push_back(d->at(c1));
    }
    inline void setYData(vector<double> *d){
      dataY.clear();
      for(unsigned int c1=0;c1<d->size();c1++) dataY.push_back(d->at(c1));
    }
    inline void setEvals(vector<double> d){
      eval.clear();
      eval.push_back(d[0]);
      eval.push_back(d[1]);
    }    
    inline void setPops(vector<int> *d){
      pops.clear();
      for(unsigned int c1=0;c1<d->size();c1++) pops.push_back(d->at(c1));
    }
    inline void setPopNames(wxArrayString s){
      popnames=s;
    }
    void OnErase(wxEraseEvent& event){};
    void OnPaint(wxPaintEvent& event);
    void OnSize(wxSizeEvent& event); 
    void show(wxDC&  dc);
    void exportToFile(const wxString& filename) ;
    wxColour getCol(int val);
    wxColour getColNorm(double val);
    inline void setNumPops(int val){
      numpops=val;
    }
    inline void setPtSize(int val){
      ptsize=val;
    }
    inline wxString getPtSize(){
      wxString ret;
      ret<<ptsize;
      return(ret);
    }
    inline void setLegSize(int val){
      legfontsize=val;
    }
    inline wxString getLegSize(){
      wxString ret;
      ret<<legfontsize;
      return(ret);
    }
    inline void setLegLoc(int val){
      if(val>=0 && val<4) legloc=val;
    }
    inline void setSecSym(int val){
      if(val>=0 && val<2) secondsymbol=val;
    }
    inline int getSecSym(){
      return(secondsymbol);
    }
  protected:
    int numpops;
    vector<double> dataX;
    vector<double> dataY;
    vector<double> eval;
    vector<int> pops;
    vector<double> dataX2;
    vector<double> dataY2;
    vector<double> eval2;
    vector<int> pops2;
    wxString nameX;
    wxString nameY;
    double borderx,bordery;
    double labx,laby;
    wxArrayString popnames;   
    int ptsize;
    int legfontsize;
    int legloc;
    int secondsymbol;
};

class PcaPlot : public wxFrame
{
public:
  PcaPlot(InputData *inputdata,InputData *inputdata2,const wxString& title);
  void OnQuit(wxCommandEvent & event);
  void OnExport(wxCommandEvent & event);
  void OnExportCsv(wxCommandEvent & event);
  void OnHelp(wxCommandEvent & event);
  void OnChoice(wxCommandEvent & event);
  inline void OnChoice2(wxCommandEvent & event){setPlot();}
  void setPlot();
  void svdOfData(int matnum);
  
  inline int getChoice(int which){
    for(unsigned int c1=0;c1<pcompnames.GetCount();c1++){
      if(which==1) if(plotComp1->GetValue()==pcompnames[c1]) return(c1);
      if(which==2) if(plotComp2->GetValue()==pcompnames[c1]) return(c1);
    }
    return(-1);
  }
    inline void OnPtSize(wxCommandEvent& event){
      int newx=wxAtoi(ptsizectrl->GetValue());
      if(newx<=0){
	ptsizectrl->SetValue(drawdisplay->getPtSize());
      }else drawdisplay->setPtSize(newx);
      drawdisplay->Refresh();
    }       
    inline void OnLegSize(wxCommandEvent& event){
      int newx=wxAtoi(legsizectrl->GetValue());
      if(newx<=0){
	legsizectrl->SetValue(drawdisplay->getPtSize());
      }else drawdisplay->setLegSize(newx);
      drawdisplay->Refresh();
    }       
    void OnLegLoc(wxCommandEvent & event);
    void OnAltPt(wxCommandEvent & event);
  protected:
// LAYOUT
  int scrollsize;
  wxPanel *panel;
  wxPanel *panelTop;
  PlotSpacePCA *drawdisplay;
  
  wxFlexGridSizer *fgs;
  wxFlexGridSizer *fgsTop;
  wxScrolledWindow *finescroller;
  wxScrolledWindow *sidescroller;

//
  wxButton *closeButton;
  wxButton *HelpButton;
  wxButton *ExportButton;
  wxButton *CsvButton;
  wxComboBox *plotComp1;
  wxComboBox *plotComp2; 
  wxTextCtrl *ptsizectrl;
  wxTextCtrl *legsizectrl;
  wxComboBox *legloc; 
  wxComboBox *altptctrl;   
  // CONTENT
  InputData *inputdata;
  InputData *inputdata2;
  vector<vector<double> > svdM;
  vector<double> eval;
  vector<int> pops;
  int numpops;
  wxArrayString pcompnames;
  wxArrayString popnames;
};

#endif
