
#include "mainwin.h"
#include "finegui.xpm"
#include <wx/stdpaths.h>
#include <wx/filename.h>

FineMainWindow::FineMainWindow(const wxString& title)
       : wxFrame(NULL, wxID_ANY, title, wxDefaultPosition, wxSize(280, 180))
{
  inputdata=new InputData();
  inputdata2=new InputData();
  settings=NULL;
  menubar = new wxMenuBar;
  file = new wxMenu;
  organise = new wxMenu;
  view = new wxMenu;
  view2 = new wxMenu;
  plot = new wxMenu;
  data2inuse=false;
  this->settings=settings;
  datawin=NULL;
  datawin2=NULL;
  showdisplay=false;
  //wxIcon icon(wxICON();
  //wxIcon icon(wxT("./finegui.ico"),wxBITMAP_TYPE_ICO);
  #if defined(__WXMSW__)
  wxStandardPaths path;
  wxString iconloc=path.GetDataDir().Append(wxT("\\finegui.ico"));
  wxIcon icon(iconloc,wxBITMAP_TYPE_ICO);
  #else
  wxIcon icon(finegui_xpm);
  #endif
  SetIcon(icon);
// SetIcon(wxIcon(wxT("finegui.xpm")));

//  SetIcon(wxIcon(wxT("finegui.xpm")));

  file->Append(FINEMAINWINDOW_ID_NEW, wxT("&New Session"));
  file->Append(wxID_OPEN, wxT("Manage &Files"));
  file->Append(FINEMAINWINDOW_ID_OPEN2, wxT("Manage Second dataset"));
  //file->Append(wxID_ANY, wxT("&Save"));
  file->Append(FINEMAINWINDOW_ID_EXPORT, wxT("&Export to image"));
  //file->Append(FINEMAINWINDOW_ID_EXPORTPS, wxT("&Export to postscript"));
  file->AppendSeparator();

//  imp = new wxMenu;
//  imp->Append(wxID_ANY, wxT("Import newsfeed list..."));
//  imp->Append(wxID_ANY, wxT("Import bookmarks..."));
//  imp->Append(wxID_ANY, wxT("Import mail..."));

//  file->AppendSubMenu(imp, wxT("I&mport"));

  quit = new wxMenuItem(file, wxID_EXIT, wxT("&Quit\tCtrl+W"));
  file->Append(quit);


  organise->Append(FINEMAINWINDOW_EDIT_NAMES, wxT("Rename Individuals"));
  organise->Append(FINEMAINWINDOW_EDIT_POPS, wxT("Rename Populations"));
  organise->Append(FINEMAINWINDOW_REORDER_POPS, wxT("Reorder Continents"));
  organise->Append(FINEMAINWINDOW_LABEL_INDS, wxT("Classify Individuals"));
  organise->Append(FINEMAINWINDOW_SCALECHOOSER, wxT("Change colour scale"));  

  viewData=new wxMenuItem(view, FINEMAINWINDOW_ID_VIEWDATA, wxT("Raw copy data"),wxT("TEST"),wxITEM_CHECK);
  viewaggregatedData=new wxMenuItem(view, FINEMAINWINDOW_ID_VIEWAGDATA, wxT("Aggregated copy data"),wxT("TEST"),wxITEM_CHECK);
  viewaggregatedDataSimple=new wxMenuItem(view, FINEMAINWINDOW_ID_VIEWAGDATASIMPLE, wxT("Aggregated (alternative)"),wxT("TEST"),wxITEM_CHECK);
  viewCoincidence=new wxMenuItem(view, FINEMAINWINDOW_ID_VIEWPC, wxT("Pairwise Coincidence"),wxT("TEST"),wxITEM_CHECK);
  view->Append(viewData);
  view->Append(viewaggregatedData);
  view->Append(viewaggregatedDataSimple);
  view->Append(viewCoincidence);

  view2Enable=new wxMenuItem(view2, FINEMAINWINDOW_ID_VIEW2ENABLE, wxT("Enable Alternative Diagonal View"),wxT("TEST"),wxITEM_CHECK);
  view2AltData=new wxMenuItem(view2, FINEMAINWINDOW_ID_VIEW2ALTDATA, wxT("Use second dataset"),wxT("TEST"),wxITEM_CHECK);
  view2Data=new wxMenuItem(view2, FINEMAINWINDOW_ID_VIEW2DATA, wxT("Raw copy data"),wxT("TEST"),wxITEM_CHECK);
  view2aggregatedData=new wxMenuItem(view2, FINEMAINWINDOW_ID_VIEW2AGDATA, wxT("Aggregated copy data"),wxT("TEST"),wxITEM_CHECK);
  view2Coincidence=new wxMenuItem(view2, FINEMAINWINDOW_ID_VIEW2PC, wxT("Pairwise Coincidence"),wxT("TEST"),wxITEM_CHECK);
  view2->Append(view2Enable);
  view2->Append(view2AltData);
  view2->Append(view2Data);
  view2->Append(view2aggregatedData);
  view2->Append(view2Coincidence);

  plotMCMC=new wxMenuItem(plot, FINEMAINWINDOW_ID_PLOTMCMC, wxT("MCMC traces"),wxT("TEST"));
  plotPCA=new wxMenuItem(plot, FINEMAINWINDOW_ID_PLOTPCA, wxT("Principal Components Analysis"),wxT("TEST"));

  plot->Append(plotMCMC);
  plot->Append(plotPCA);

  menubar->Append(file, wxT("&File"));
  menubar->Append(organise, wxT("&Organise"));
  menubar->Append(view, wxT("&View"));
  menubar->Append(view2, wxT("&Second View"));
  menubar->Append(plot, wxT("&Plot"));
  SetMenuBar(menubar);
  viewData->Enable(false);
  viewaggregatedData->Enable(false);
  viewaggregatedDataSimple->Enable(false);
  viewCoincidence->Enable(false);

  checkView2Enable(false);
  view2Data->Enable(false);
  view2aggregatedData->Enable(false);
  view2Coincidence->Enable(false);

  Connect(wxID_EXIT, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnQuit));
  Connect(wxID_OPEN, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnOpen));
  Connect(FINEMAINWINDOW_ID_OPEN2, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnOpen2));
  Connect(FINEMAINWINDOW_ID_NEW, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnNew));
  Connect(FINEMAINWINDOW_ID_EXPORT, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnExport));
  Connect(FINEMAINWINDOW_ID_EXPORTPS, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnExportPS));
  Connect(FINEMAINWINDOW_REORDER_POPS, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnReorderPops));
  Connect(FINEMAINWINDOW_EDIT_NAMES, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnEditNames));
  Connect(FINEMAINWINDOW_EDIT_POPS, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnEditPops));
  Connect(FINEMAINWINDOW_LABEL_INDS, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnLabelInds));
  Connect(FINEMAINWINDOW_SCALECHOOSER, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnScaleChooser));
  Connect(FINEMAINWINDOW_ID_VIEWDATA, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnViewData));
  Connect(FINEMAINWINDOW_ID_VIEWAGDATA, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnViewAgData));
  Connect(FINEMAINWINDOW_ID_VIEWAGDATASIMPLE, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnViewAgDataSimple));
  Connect(FINEMAINWINDOW_ID_VIEWPC, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnViewPC));
  Connect(FINEMAINWINDOW_ID_VIEW2ENABLE, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnView2Enable));
  Connect(FINEMAINWINDOW_ID_VIEW2ALTDATA, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnView2AltData));
  Connect(FINEMAINWINDOW_ID_VIEW2DATA, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnView2Data));
  Connect(FINEMAINWINDOW_ID_VIEW2AGDATA, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnView2AgData));
  Connect(FINEMAINWINDOW_ID_VIEW2PC, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnView2PC));
  Connect(FINEMAINWINDOW_ID_PLOTMCMC, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnPlotMCMC));
  Connect(FINEMAINWINDOW_ID_PLOTPCA, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(FineMainWindow::OnPlotPCA));
  SetMinSize(wxSize(720,540));

  scrollsize=50;
  panel = new wxPanel(this, -1);
  fgs = new wxFlexGridSizer(1,2,0,0);

  int sidescollsize=25;
  sidescroller= new  wxScrolledWindow(panel, -1, wxPoint(0,0), wxSize(180,-1), wxVSCROLL);
  sidescroller->SetMinSize(wxSize(180,-1));
  panelTop = new wxPanel(sidescroller,-1, wxPoint(0,0), wxSize(160,800));
  panelTop->SetMinSize( wxSize(160,800));
  sidescroller->SetScrollbars(sidescollsize, sidescollsize, sidescroller->GetSize().x/sidescollsize, sidescroller->GetSize().y/sidescollsize);
  sidescroller->Scroll(0,0);
  wxBoxSizer *tsideslider=new wxBoxSizer(wxHORIZONTAL);
  tsideslider->Add(panelTop);
    sidescroller->SetSizer(tsideslider);
  tsideslider->SetVirtualSizeHints(sidescroller);

  finescroller= new  wxScrolledWindow(panel, -1, wxDefaultPosition, wxDefaultSize, wxHSCROLL | wxVSCROLL);
  finescroller->SetScrollbars(scrollsize, scrollsize, finescroller->GetMinSize().x/scrollsize, finescroller->GetMinSize().y/scrollsize);
  finescroller->Scroll(0,0);

  wxBoxSizer *tslider=new wxBoxSizer(wxHORIZONTAL);
  finedisplay = new FineDisplay(inputdata,inputdata2,finescroller, wxID_ANY);

  tslider->Add(finedisplay);
  finescroller->SetSizer(tslider);
//  fgs->Add(panelTop, 1, wxALL | wxFIXED_MINSIZE, 15);
//  fgs->Add(sidescroller, 1, wxALL | wxFIXED_MINSIZE, 15);
  fgs->Add(sidescroller, 1, wxALL | wxEXPAND, 5);
  fgs->Add(finescroller, 1, wxALL | wxEXPAND, 5);

//  refreshpanel = new wxPanel(panel, -1,wxDefaultPosition, wxDefaultSize, wxBORDER_SUNKEN);
//  refreshpanel->SetMinSize(wxSize(160,65));
  autoRefreshBox = new wxCheckBox(panelTop, FINEMAINWINDOW_ID_SHOWDISPLAY, wxT("Display"));
  autoRefreshBox->SetValue(showdisplay);  
  refreshButton=new wxButton(panelTop, FINEMAINWINDOW_ID_REFRESHBUTTON, wxT("Refresh"));  

  wxBoxSizer * refresh_horiz=new wxBoxSizer(wxHORIZONTAL);
  refresh_horiz->Add(autoRefreshBox);
  refresh_horiz->Add(refreshButton);
  
  showXlab = new wxCheckBox(panelTop, FINEMAINWINDOW_ID_SHOWXLAB, wxT("Show X labels?"));
  showYlab = new wxCheckBox(panelTop, FINEMAINWINDOW_ID_SHOWYLAB, wxT("Show Y labels?"));
  showXtree = new wxCheckBox(panelTop, FINEMAINWINDOW_ID_SHOWXTREE, wxT("Show X tree?"));
  showYtree = new wxCheckBox(panelTop, FINEMAINWINDOW_ID_SHOWYTREE, wxT("Show Y tree?"));
  showScale = new wxCheckBox(panelTop, FINEMAINWINDOW_ID_SHOWSCALE, wxT("Show scale?"));
  showXlab->SetValue(false);
  showYlab->SetValue(false);
  showXtree->SetValue(false);
  showYtree->SetValue(false);
  showScale->SetValue(true);

  wxSize fssize=finedisplay->getSize();
  wxString fssizex;fssizex<<fssize.x;
  wxString fssizey;fssizey<<fssize.y;
  wholeXsize = new wxTextCtrl(panelTop, FINEMAINWINDOW_ID_XSIZE, fssizex, wxDefaultPosition, wxSize(50,-1), wxTE_PROCESS_ENTER , wxDefaultValidator, wxTextCtrlNameStr);
  wholeYsize = new wxTextCtrl(panelTop, FINEMAINWINDOW_ID_YSIZE, fssizey, wxDefaultPosition, wxSize(50,-1), wxTE_PROCESS_ENTER , wxDefaultValidator, wxTextCtrlNameStr);

  treeXsize = new wxTextCtrl(panelTop, FINEMAINWINDOW_ID_TREEXSIZE, finedisplay->getXlabelSizeWx(), wxDefaultPosition, wxSize(50,-1), wxTE_PROCESS_ENTER , wxDefaultValidator, wxTextCtrlNameStr);
  treeYsize = new wxTextCtrl(panelTop, FINEMAINWINDOW_ID_TREEYSIZE, finedisplay->getYlabelSizeWx(), wxDefaultPosition, wxSize(50,-1), wxTE_PROCESS_ENTER , wxDefaultValidator, wxTextCtrlNameStr);

  treePenWidth = new wxTextCtrl(panelTop, FINEMAINWINDOW_ID_TREEPENWIDTH, finedisplay->getTreeWidthWx(), wxDefaultPosition, wxSize(50,-1), wxTE_PROCESS_ENTER , wxDefaultValidator, wxTextCtrlNameStr);

  labelXsize = new wxTextCtrl(panelTop, FINEMAINWINDOW_ID_LABELXSIZE, finedisplay->getXtreeSizeWx(), wxDefaultPosition, wxSize(50,-1), wxTE_PROCESS_ENTER , wxDefaultValidator, wxTextCtrlNameStr);
  labelYsize = new wxTextCtrl(panelTop, FINEMAINWINDOW_ID_LABELYSIZE, finedisplay->getYtreeSizeWx(), wxDefaultPosition, wxSize(50,-1), wxTE_PROCESS_ENTER , wxDefaultValidator, wxTextCtrlNameStr);

  fontSize = new wxTextCtrl(panelTop, FINEMAINWINDOW_ID_FONTSIZE, finedisplay->getFontSizeWx(), wxDefaultPosition, wxSize(50,-1), wxTE_PROCESS_ENTER , wxDefaultValidator, wxTextCtrlNameStr);

  usePopLabels = new wxCheckBox(panelTop, FINEMAINWINDOW_ID_USEPOPLABELS, wxT("Population labels?"));
  perpPopLabels = new wxCheckBox(panelTop, FINEMAINWINDOW_ID_PERPPOPLABELS, wxT("Perpendicular?"));
  useClassifyLabels = new wxCheckBox(panelTop, FINEMAINWINDOW_ID_CLASSIFYLABELS, wxT("Label Classification?"));

  classificationSize = new wxTextCtrl(panelTop, FINEMAINWINDOW_ID_CLASSIFYSIZE, finedisplay->getClassificationSizeWx(), wxDefaultPosition, wxSize(50,-1), wxTE_PROCESS_ENTER , wxDefaultValidator, wxTextCtrlNameStr);
  scaleWidth = new wxTextCtrl(panelTop, FINEMAINWINDOW_ID_SCALEWIDTH, finedisplay->getScaleSizeWx(), wxDefaultPosition, wxSize(50,-1), wxTE_PROCESS_ENTER , wxDefaultValidator, wxTextCtrlNameStr);
  scaleBarSize = new wxTextCtrl(panelTop, FINEMAINWINDOW_ID_SCALEBARSIZE, finedisplay->getScaleBarSizeWx(), wxDefaultPosition, wxSize(50,-1), wxTE_PROCESS_ENTER , wxDefaultValidator, wxTextCtrlNameStr);
  scaleTextSize = new wxTextCtrl(panelTop, FINEMAINWINDOW_ID_SCALETEXTSIZE, finedisplay->getScaleTextSizeWx(), wxDefaultPosition, wxSize(50,-1), wxTE_PROCESS_ENTER , wxDefaultValidator, wxTextCtrlNameStr);
  scaleFormat = new wxTextCtrl(panelTop, FINEMAINWINDOW_ID_SCALEFORMAT, finedisplay->getScaleFormat(), wxDefaultPosition, wxSize(50,-1), wxTE_PROCESS_ENTER , wxDefaultValidator, wxTextCtrlNameStr);
  scaleMin = new wxTextCtrl(panelTop, FINEMAINWINDOW_ID_SCALEMIN, finedisplay->getScaleMinWx(), wxDefaultPosition, wxSize(50,-1), wxTE_PROCESS_ENTER , wxDefaultValidator, wxTextCtrlNameStr);
  scaleMax = new wxTextCtrl(panelTop, FINEMAINWINDOW_ID_SCALEMAX, finedisplay->getScaleMaxWx(), wxDefaultPosition, wxSize(50,-1), wxTE_PROCESS_ENTER , wxDefaultValidator, wxTextCtrlNameStr);

  sepContScale=new wxCheckBox(panelTop, FINEMAINWINDOW_ID_SEPCONTSCALE, wxT("Rescale Continents?"));
  showContinentRows= new wxCheckBox(panelTop, FINEMAINWINDOW_ID_USECONTINENTROWS, wxT("Continent Rows?"));
  showContinentCols= new wxCheckBox(panelTop, FINEMAINWINDOW_ID_USECONTINENTCOLS, wxT("Continent Cols?"));

  contSize = new wxTextCtrl(panelTop, FINEMAINWINDOW_ID_CONTSIZE, inputdata->getContSizeWx(), wxDefaultPosition, wxSize(50,-1), wxTE_PROCESS_ENTER , wxDefaultValidator, wxTextCtrlNameStr);
  
  popSizeScale = new wxTextCtrl(panelTop, FINEMAINWINDOW_ID_POPSCALE,finedisplay->getPopSizeScaleWx(), wxDefaultPosition, wxSize(50,-1), wxTE_PROCESS_ENTER , wxDefaultValidator, wxTextCtrlNameStr);

  fgsTop = new wxFlexGridSizer(19, 1, 9, 10);

  fgsTop->Add(refresh_horiz);
  fgsTop->Add(showXlab);
  fgsTop->Add(showYlab);
  fgsTop->Add(showXtree);
  fgsTop->Add(showYtree);
  fgsTop->Add(showScale);

  wxBoxSizer * wholesize_vert=new wxBoxSizer(wxVERTICAL);
  wxBoxSizer * wholesize_horiz=new wxBoxSizer(wxHORIZONTAL);
  wholesize_vert->Add(new wxStaticText(panelTop, -1, wxT("Dimensions:")));
  wholesize_horiz->Add(wholeXsize);
  wholesize_horiz->Add(new wxStaticText(panelTop, -1, wxT("by")));
  wholesize_horiz->Add(wholeYsize);
  wholesize_vert->Add(wholesize_horiz);
  fgsTop->Add(wholesize_vert);

  wxBoxSizer * treesize_vert=new wxBoxSizer(wxVERTICAL);
  wxGridSizer * treesize_horiz=new wxGridSizer(2,2,0,0);
  treesize_vert->Add(new wxStaticText(panelTop, -1, wxT("Tree Display Size:")));
  treesize_horiz->Add(new wxStaticText(panelTop, -1, wxT("X:")));
  treesize_horiz->Add(treeXsize);
  treesize_horiz->Add(new wxStaticText(panelTop, -1, wxT("Y:")));
  treesize_horiz->Add(treeYsize);
  treesize_vert->Add(treesize_horiz);
  fgsTop->Add(treesize_vert);

  wxGridSizer * treepen_horiz=new wxGridSizer(1,2,0,0);
  treepen_horiz->Add(new wxStaticText(panelTop, -1, wxT("Tree Width:")));
  treepen_horiz->Add(treePenWidth);
  fgsTop->Add(treepen_horiz);

  wxBoxSizer * labsize_vert=new wxBoxSizer(wxVERTICAL);
  wxGridSizer * labsize_horiz=new wxGridSizer(2,2,0,0);
  labsize_vert->Add(new wxStaticText(panelTop, -1, wxT("Label Display Size:")));
  labsize_horiz->Add(new wxStaticText(panelTop, -1, wxT("X:")));
  labsize_horiz->Add(labelXsize);
  labsize_horiz->Add(new wxStaticText(panelTop, -1, wxT("Y:")));
  labsize_horiz->Add(labelYsize);
  labsize_vert->Add(labsize_horiz);
  fgsTop->Add(labsize_vert);

  wxGridSizer * fontsize_horiz=new wxGridSizer(1,2,0,0);
  fontsize_horiz->Add(new wxStaticText(panelTop, -1, wxT("Label size:")));
  fontsize_horiz->Add(fontSize);
  fgsTop->Add(fontsize_horiz);

  //wxGridSizer * fontsize_horiz=new wxGridSizer(1,2,0,0);
  wxGridSizer * usepopsize_horiz=new wxGridSizer(3,1,0,0);
  usepopsize_horiz->Add(usePopLabels);
  usepopsize_horiz->Add(perpPopLabels);
  usepopsize_horiz->Add(useClassifyLabels);
  checkUsePopLabels(finedisplay->getUsePopLabels());
  checkPerpPopLabels(finedisplay->getPerpPopLabels());
  checkUseClassifyLabels(finedisplay->getUseClassifyLabels());
   fgsTop->Add(usepopsize_horiz);


// Scale stuff, with a label box squeezed on top
  wxFlexGridSizer * scale_fgs=new wxFlexGridSizer(6,2,0,0);
  scale_fgs->Add(new wxStaticText(panelTop, -1, wxT("Label Box Size")));
  scale_fgs->Add(classificationSize);
  scale_fgs->Add(new wxStaticText(panelTop, -1, wxT("Scale Size")));
  scale_fgs->Add(scaleWidth);
  scale_fgs->Add(new wxStaticText(panelTop, -1, wxT("Scale bar size")));
  scale_fgs->Add(scaleBarSize);
  scale_fgs->Add(new wxStaticText(panelTop, -1, wxT("Scale text size")));
  scale_fgs->Add(scaleTextSize);
  scale_fgs->Add(new wxStaticText(panelTop, -1, wxT("Scale format")));
  scale_fgs->Add(scaleFormat);
  scale_fgs->Add(new wxStaticText(panelTop, -1, wxT("Scale min")));
  scale_fgs->Add(scaleMin);
  scale_fgs->Add(new wxStaticText(panelTop, -1, wxT("Scale max")));
  scale_fgs->Add(scaleMax);
  fgsTop->Add(scale_fgs);

 // Continent stuff
  wxGridSizer * contsize_horiz=new wxGridSizer(4,1,0,0);

  checkUseContinentRows(finedisplay->getUseContinentRows());
  checkUseContinentCols(finedisplay->getUseContinentCols());
  checkSepContScale(inputdata->getUseMod());
  contsize_horiz->Add(sepContScale);
  contsize_horiz->Add(showContinentRows);
  contsize_horiz->Add(showContinentCols);

  wxFlexGridSizer * cont_fgs=new wxFlexGridSizer(1,2,0,0);
  cont_fgs->Add(new wxStaticText(panelTop, -1, wxT("Continent Size")));
  cont_fgs->Add(contSize);
  contsize_horiz->Add(cont_fgs);

  fgsTop->Add(contsize_horiz);

  wxFlexGridSizer * popsize_fgs=new wxFlexGridSizer(1,2,0,0);
  popsize_fgs->Add(new wxStaticText(panelTop, -1, wxT("Population Scale")));
  popsize_fgs->Add(popSizeScale);
 
  fgsTop->Add(popsize_fgs);

  //checkUseClassifyLabels(finedisplay->getUseClassifyLabels());

  fgsTop->AddGrowableCol(0,1);


// add sizers to everything
  fgs->AddGrowableRow(0, 1);
  fgs->AddGrowableCol(1, 1);
    panelTop->SetSizerAndFit(fgsTop);
//  panelTop->SetSizer(fgsTop);
  panel->SetSizer(fgs);

  // Default loading for tests
/*  inputdata->setCopyDir(wxT("."));
  inputdata->setFixedDir(wxT("."));
  inputdata->setMcmcDir(wxT("."));
  inputdata->setTreeDir(wxT("."));
  inputdata->setCopyName(wxT(""));
  inputdata->setFixedName(wxT(""));
  inputdata->setMcmcName(wxT(""));
  inputdata->setTreeName(wxT(""));*/

//  inputdata2->setCopyDir(wxT("."));
//  inputdata2->setCopyName(wxT("test.nmat"));
//  inputdata->readCopyFile();
//  enableViewRawData();
//  finedisplay->refreshGrid();

//  inputdata2->setMcmcDir(wxT("."));
//  inputdata2->setMcmcName(wxT("test2.xml"));

//  inputdata2->setTreeDir(wxT("."));
//  inputdata2->setTreeName(wxT("testtree2.xml"));
  //inputdata->generateTree();
/*    inputdata->readTree();
  checkXtree(true);
  checkYtree(true);
  enableViewAggregatedData();
*/
  finedisplay->fit();
  Update();
  Refresh();

  Connect(FINEMAINWINDOW_ID_SHOWDISPLAY, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(FineMainWindow::OnRefreshChecked));
  Connect(FINEMAINWINDOW_ID_REFRESHBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(FineMainWindow::OnRefreshButton));
  Connect(FINEMAINWINDOW_ID_SHOWXLAB, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(FineMainWindow::OnXlabCbx));
  Connect(FINEMAINWINDOW_ID_SHOWYLAB, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(FineMainWindow::OnYlabCbx));
  Connect(FINEMAINWINDOW_ID_SHOWXTREE, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(FineMainWindow::OnXtreeCbx));
  Connect(FINEMAINWINDOW_ID_SHOWYTREE, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(FineMainWindow::OnYtreeCbx));
  Connect(FINEMAINWINDOW_ID_SHOWSCALE, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(FineMainWindow::OnShowScale));
  Connect(FINEMAINWINDOW_ID_XSIZE, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler(FineMainWindow::OnXsizeCtl));
  Connect(FINEMAINWINDOW_ID_YSIZE, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler(FineMainWindow::OnYsizeCtl));
  Connect(FINEMAINWINDOW_ID_TREEXSIZE, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler(FineMainWindow::OnTreeXsizeCtl));
  Connect(FINEMAINWINDOW_ID_TREEYSIZE, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler(FineMainWindow::OnTreeYsizeCtl));
  Connect(FINEMAINWINDOW_ID_LABELXSIZE, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler(FineMainWindow::OnLabelXsizeCtl));
  Connect(FINEMAINWINDOW_ID_LABELYSIZE, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler(FineMainWindow::OnLabelYsizeCtl));
  Connect(FINEMAINWINDOW_ID_TREEPENWIDTH, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler(FineMainWindow::OnTreePenWidth));
  Connect(FINEMAINWINDOW_ID_FONTSIZE, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler(FineMainWindow::OnFontSize));
  Connect(FINEMAINWINDOW_ID_USEPOPLABELS, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(FineMainWindow::OnUsePopLabels));
  Connect(FINEMAINWINDOW_ID_PERPPOPLABELS, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(FineMainWindow::OnPerpPopLabels));
  Connect(FINEMAINWINDOW_ID_CLASSIFYLABELS, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(FineMainWindow::OnUseClassifyLabels));
  Connect(FINEMAINWINDOW_ID_CLASSIFYSIZE, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler(FineMainWindow::OnClassificationLabelSize));
  Connect(FINEMAINWINDOW_ID_SCALEWIDTH, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler(FineMainWindow::OnScaleWidth));
  Connect(FINEMAINWINDOW_ID_SCALEBARSIZE, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler(FineMainWindow::OnScaleBarSize));
  Connect(FINEMAINWINDOW_ID_SCALETEXTSIZE, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler(FineMainWindow::OnScaleTextSize));
  Connect(FINEMAINWINDOW_ID_SCALEFORMAT, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler(FineMainWindow::OnScaleFormat));
  Connect(FINEMAINWINDOW_ID_SCALEMIN, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler(FineMainWindow::OnScaleMin));
  Connect(FINEMAINWINDOW_ID_SCALEMAX, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler(FineMainWindow::OnScaleMax));
  Connect(FINEMAINWINDOW_ID_SEPCONTSCALE, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(FineMainWindow::OnSepContScale));
  Connect(FINEMAINWINDOW_ID_USECONTINENTROWS, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(FineMainWindow::OnUseContinentRows));
  Connect(FINEMAINWINDOW_ID_USECONTINENTCOLS, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(FineMainWindow::OnUseContinentCols));
  Connect(FINEMAINWINDOW_ID_CONTSIZE, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler(FineMainWindow::OnContSize));
  Connect(FINEMAINWINDOW_ID_POPSCALE, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler(FineMainWindow::OnPopSizeScale));
  Centre();
  
  autoRefreshBox->SetToolTip(wxT("Toggles whether the display is visible (useful for large datasets)"));
  refreshButton->SetToolTip(wxT("Apply all settings and redraw the display"));
  showXlab->SetToolTip(wxT("Display the left label area?"));
  showYlab->SetToolTip(wxT("Display the top label area?"));
  showXtree->SetToolTip(wxT("Display the left tree area?"));
  showYtree->SetToolTip(wxT("Display the top tree area?"));
  showScale->SetToolTip(wxT("Display the scale area?"));
  wholeXsize->SetToolTip(wxT("Width of the whole display"));
  wholeYsize->SetToolTip(wxT("Height of the whole display"));
  treeXsize->SetToolTip(wxT("Width of the left tree area"));
  treeYsize->SetToolTip(wxT("Height of the top tree area"));
  treePenWidth->SetToolTip(wxT("Tree pen width (integer)"));
  labelXsize->SetToolTip(wxT("Width of the left label area"));
  labelYsize->SetToolTip(wxT("Height of the top label area"));
  fontSize->SetToolTip(wxT("Font size for labels. -ve values: proportion of available space.  +ve values: size in pixels."));
  usePopLabels->SetToolTip(wxT("Display population labels (set in Organise->Rename Populations) instead of individual labels?"));
  perpPopLabels->SetToolTip(wxT("Should population labels be rotated?"));
  useClassifyLabels->SetToolTip(wxT("Display the classification box, selected in Organise->Classify Individuals"));
  classificationSize->SetToolTip(wxT("Size of classification box"));
  scaleWidth->SetToolTip(wxT("Width of the scale area"));
  scaleBarSize->SetToolTip(wxT("Width of the scale bar"));
  scaleTextSize->SetToolTip(wxT("Font size of the scale area, in pixels"));
  scaleFormat->SetToolTip(wxT("Format of the scale (c printf format).  Try %0.xf where x is the number of decimal places"));
  scaleMin->SetToolTip(wxT("Minimum value of the scale, below which entries are truncated to white. -1 for no limit."));
  scaleMax->SetToolTip(wxT("Maximum value of the scale, above which entries are truncated to black. -1 for no limit."));
  sepContScale->SetToolTip(wxT("If continents are defined via a force file, should their copy counts be scaled differently?"));
  showContinentRows->SetToolTip(wxT("If continents are defined via a force file, should they be shown on the left?"));
  showContinentCols->SetToolTip(wxT("If continents are defined via a force file, should they be shown on the top?"));
  contSize->SetToolTip(wxT("If continents are rescaled, how many individuals wide should they be?"));
  popSizeScale->SetToolTip(wxT("When in viewmode \"Aggregated (alternative)\", change the effective population sizes by this power."));
}

void FineMainWindow::OnExport(wxCommandEvent& WXUNUSED(event))
{
  wxFileDialog * openFileDialog = new wxFileDialog(this,wxT("Select file for image export (supported formats: .png, .bmp, .jpg)"),inputdata->getCopyDir(),wxT("screenshot.png"),wxT("PNG files (*.png)|*.png|BMP files (*.bmp)|*.bmp|JPG files (*.jpeg;*.jpeg)|*.jpg;*.jpeg|All Files|*"),wxFD_SAVE);
  if (openFileDialog->ShowModal() == wxID_OK){
    applySettings(autoRefreshBox->GetValue());
    acceptSizing(finedisplay->getSize());
    wxFileName tfile(openFileDialog->GetDirectory(),openFileDialog->GetFilename());
    finedisplay->exportToFile(tfile.GetFullPath());
  }
}

#include <wx/dcprint.h>
void FineMainWindow::OnExportPS(wxCommandEvent& WXUNUSED(event))
{
 /*   wxPrintDialogData g_printDialogData;//= printD.GetPrintDialogData();
    wxPrintDialog printD(this,&g_printDialogData);
    printD.ShowModal();
    wxDC *printdc=printD.GetPrintDC();
   // finedisplay->exportToFile(tfile.GetFullPath());
      printdc->SetPen(wxPen(wxColour(0, 255,0)));
  printdc->SetBrush(wxBrush(wxColour(0, 255,0)));
    printdc->DrawCircle(40,40,10);*/
  /*
  wxFileDialog * openFileDialog = new wxFileDialog(this,wxT("Select file for image export (supported formats: .ps)"),inputdata->getCopyDir(),wxT("screenshot.ps"),wxT("Postscript files (*.ps)|*.ps|All Files|*"),wxFD_SAVE);
  if (openFileDialog->ShowModal() == wxID_OK){
    wxFileName tfile(openFileDialog->GetDirectory(),openFileDialog->GetFilename());
 //   printD.Show();
 //    finedisplay->exportToFile(tfile.GetFullPath());
    wxPrinter printer(& g_printDialogData);
    MyPrintout printout(wxT("My printout"));

    if (!printer.Print(this, &printout, true))
    {
        if (wxPrinter::GetLastError() == wxPRINTER_ERROR)
            wxMessageBox(wxT("There was a problem printing.\nPerhaps your current printer is not set correctly?"), wxT("Printing"), wxOK);
        else
            wxMessageBox(wxT("You cancelled printing"),
                         wxT("Printing"), wxOK);
    }
    else
    {
        (*g_printDialogData) = printer.GetPrintDialogData();
    }

  }*/
}

void FineMainWindow::OnQuit(wxCommandEvent& WXUNUSED(event))
{
  Close(true);
}

void FineMainWindow::OnOpen(wxCommandEvent& event)
{
    datawin=new DataWindow(settings,inputdata,finedisplay,true,this,(wxPanel*)this,wxID_ANY,wxT("Input Finestructure data"));
  datawin->Show();
}

void FineMainWindow::SetupInputData2()
{
  if(!data2inuse){
    data2inuse=true;
    inputdata2->setCopyDir(inputdata->getCopyDir());
    inputdata2->setCopyName(inputdata->getCopyName());
    inputdata2->setMcmcDir(inputdata->getMcmcDir());
    inputdata2->setMcmcName(inputdata->getMcmcName());
    inputdata2->setTreeDir(inputdata->getTreeDir());
    inputdata2->setTreeName(inputdata->getTreeName());
    inputdata2->setFixedDir(inputdata->getFixedDir());
    inputdata2->setFixedName(inputdata->getFixedName());
    inputdata2->setUseFixed(inputdata->getUseFixed());
  }
}

void FineMainWindow::OnOpen2(wxCommandEvent& event)
{
  SetupInputData2();
  datawin2=new DataWindow(settings,inputdata2,finedisplay,false,this,(wxPanel*)this,wxID_ANY,wxT("Input Finestructure second data"));
  datawin2->Show();
}


void FineMainWindow::OnNew(wxCommandEvent& event)
{
  unloadAllFiles();
}

void FineMainWindow::OnEditNames(wxCommandEvent& event)
{
  nameswindow=new NamesWindow(inputdata,(wxPanel*) this,wxID_ANY,wxT("Edit Names"));
  nameswindow->Show();
}

void FineMainWindow::OnReorderPops(wxCommandEvent& event)
{
  ReorderAll * reorderall = new ReorderAll(inputdata,(wxPanel*)this,wxID_ANY,wxT("Reorder Continents / PCA order"));
  reorderall->Show();
}

void FineMainWindow::OnEditPops(wxCommandEvent& event)
{
  if(inputdata->getNumPops()<=1){
    wxMessageBox(wxT("No populations found.  You need to generate or load a valid tree file first."),wxT("No populations"));

  }else{
    popswindow=new PopsWindow(inputdata,(wxPanel*) this,wxID_ANY,wxT("Edit Populations"));
    popswindow->Show();
  }
}

void FineMainWindow::OnLabelInds(wxCommandEvent& event)
{
  labelwindow=new LabelWindow(inputdata,finedisplay,(wxPanel*) this,wxID_ANY,wxT("C Individuals"));
  labelwindow->Show();
}

void FineMainWindow::OnScaleChooser(wxCommandEvent& event)
{
  scalechooser=new ScaleChooser(finedisplay->getHeatmap(),(wxPanel*) this,wxID_ANY,wxT("Assign Scale Colours"));
  scalechooser->Show();
}

void FineMainWindow::loadDefaults(){

}

void FineMainWindow::unloadAllFiles()
{
  bool wasshowing=showdisplay;
  setShowDisplay(false);
  data2inuse=false;
  checkXtree(false);
  checkYtree(false);
  checkXlabels(false);
  checkYlabels(false);
  enableViewRawData(false);
  enableViewAggregatedData(false);
  enableViewPairwiseCoincidence(false);
  finedisplay->setLabelCol(NULL,vector<wxColour>());
  finedisplay->setHeatmapAsCopy();
  finedisplay->refreshGrid();
  inputdata->unloadTreeFile();
  inputdata->unloadMcmcFile();
  inputdata->unloadCopyFile();
  inputdata2->unloadTreeFile();
  inputdata2->unloadMcmcFile();
  inputdata2->unloadCopyFile();
  inputdata->setAllLabels(vector<wxString>(),vector<int>());
  setShowDisplay(wasshowing);
  menubar->EnableTop(3,true); 
}

void FineMainWindow::OnPlotMCMC(wxCommandEvent & event)
{
  MultiPlot * plotptr=new MultiPlot(inputdata,inputdata2,wxT("MCMC Trace plot"));
  plotptr->Show();
}

void FineMainWindow::OnPlotPCA(wxCommandEvent & event)
{
  if(!inputdata->hasData()){
    wxMessageBox(wxT("Cannot plot PCA data without first loading some data."),wxT("PCA not ready"));
  }
  PcaPlot * plotptr=new PcaPlot(inputdata,inputdata2,wxT("PCA plot"));
  plotptr->Show();
}

void FineMainWindow::applySettings(bool showafter)
{
  finedisplay->Hide();
  wxCommandEvent testcommandevent;
  acceptSizing(finedisplay->getSize());
  finedisplay->fit();
  
  OnScaleWidth(testcommandevent);
  OnScaleBarSize(testcommandevent);
  OnScaleTextSize(testcommandevent);
  OnScaleFormat(testcommandevent);
  OnScaleMin(testcommandevent);
  OnScaleMax(testcommandevent);
  finedisplay->fit();

  OnFontSize(testcommandevent);
  OnLabelXsizeCtl(testcommandevent);
  OnLabelYsizeCtl(testcommandevent);
  finedisplay->fit();

  OnXsizeCtl(testcommandevent);
  OnYsizeCtl(testcommandevent);
  OnTreePenWidth(testcommandevent);
  OnTreeXsizeCtl(testcommandevent);
  OnTreeYsizeCtl(testcommandevent);
  finedisplay->fit();
  
  OnClassificationLabelSize(testcommandevent);
  finedisplay->refreshGrid();
  if(showafter) {
    finedisplay->Show();
    acceptSizing(finedisplay->getSize());
  }
}

void FineMainWindow::setCopyFile(wxString input){
  wxFileName inputfilename(input);
  inputdata->setCopyName(inputfilename.GetFullName());
  inputdata->setCopyDir(inputfilename.GetPath());
}

void FineMainWindow::setFixedFile(wxString input){
  wxFileName inputfilename(input);
  inputdata->setFixedName(inputfilename.GetFullName());
  inputdata->setFixedDir(inputfilename.GetPath());
  inputdata->setUseFixed(true);
}

void FineMainWindow::setMcmcFile(wxString input){
  wxFileName inputfilename(input);
  inputdata->setMcmcName(inputfilename.GetFullName());
  inputdata->setMcmcDir(inputfilename.GetPath());
}

void FineMainWindow::setTreeFile(wxString input){
  wxFileName inputfilename(input);
  inputdata->setTreeName(inputfilename.GetFullName());
  inputdata->setTreeDir(inputfilename.GetPath());
}


/*
void FineMainWindow::Refresh()
{
  finedisplay->fit();
  wxFrame::Refresh();
}*/
//#endif
