
#include <wx/stdpaths.h>
#include "finegui.xpm"

#include "labelinds.h"


LabelWindow::LabelWindow(InputData *inputdata,FineDisplay *finedisplay,wxPanel *parent, int id,const wxString& title):
      wxFrame(parent, id, title, wxDefaultPosition, wxDefaultSize)
{

      #if defined(__WXMSW__)
  wxStandardPaths path;
  wxString iconloc=path.GetDataDir().Append(wxT("\\finegui.ico"));
  wxIcon icon(iconloc,wxBITMAP_TYPE_ICO);
  #else
  wxIcon icon(finegui_xpm);
  #endif
  SetIcon(icon);

  SetSize(wxSize(520,600));
  this->inputdata=inputdata;
  this->finedisplay=finedisplay;
  this->parent=parent;
//  namegrid = new wxGrid(this,-1, wxPoint(0,40), GetSize(), wxWANTS_CHARS, wxPanelNameStr);
  namegrid = new wxGrid(this,-1, wxPoint(0,30), wxSize(520,600), wxWANTS_CHARS, wxPanelNameStr);
  vsizer=new wxFlexGridSizer(2,1,0,0);
  hsizer=new wxFlexGridSizer(1,4,0,0);
  vsizer->AddGrowableRow(1);
  vsizer->AddGrowableCol(0);
  hsizer->AddGrowableCol(0);
  hsizer->AddGrowableCol(1);
  hsizer->AddGrowableCol(2);
  hsizer->AddGrowableCol(3);
  toppanel = new wxPanel(this, -1,wxDefaultPosition, wxDefaultSize, wxBORDER_NONE);
  toppanel->SetMinSize(wxSize(250,30));
  toppanel->SetSize(wxSize(250,30));
  okButton=new wxButton(toppanel, LABELINDS_ID_OKBUTTON, wxT("Accept"));
  cancelButton=new wxButton(toppanel, LABELINDS_ID_CANCELBUTTON, wxT("Cancel"));
  inferButton=new wxButton(toppanel, LABELINDS_ID_INFERBUTTON, wxT("Guess"));
  newButton=new wxButton(toppanel, LABELINDS_ID_NEWBUTTON, wxT("New Colours"));
  hsizer->Add(okButton,1,wxEXPAND);
  hsizer->Add(cancelButton,1,wxEXPAND);
  hsizer->Add(inferButton,1,wxEXPAND);
  hsizer->Add(newButton,1,wxEXPAND);
  hsizer->SetSizeHints( toppanel );
  toppanel->SetSizerAndFit(hsizer);
  namegrid->CreateGrid( inputdata->getN(), 3 );

  vector<int> * visorder = inputdata->getorder();

    // And set grid cell contents as strings
  for(int c1=0;c1<inputdata->getN();c1++){
    namegrid->SetCellValue( c1, 0, inputdata->getName(visorder->at(c1)));
    namegrid->SetCellValue( c1, 1, inputdata->getLabelWx((c1)));
    namegrid->SetReadOnly( c1, 0 );
    namegrid->SetCellBackgroundColour( c1, 0, wxColour(230,230,230));
    namegrid->SetReadOnly( c1, 2 );
    namegrid->SetCellBackgroundColour(c1, 2, finedisplay->getLabelCol(c1));
  }
  if(inputdata->getN()>0){
  namegrid->SetColLabelValue(0,wxT("         Name         "));
  namegrid->SetColLabelValue(1,wxT("         Label        "));
  namegrid->SetColLabelValue(2,wxT("         Colour       "));
  }
  vsizer->Add(toppanel,1,wxEXPAND);
  vsizer->Add(namegrid,1,wxEXPAND);
  SetSizerAndFit(vsizer);
    Fit();
//  vsizer->SetSizeHints( this);
//
  namegrid->SetColMinimalWidth( 0, 280 );
  namegrid->SetColMinimalWidth( 1, 280 );
  namegrid->SetColMinimalWidth( 2, 280 );
  namegrid->Fit();
  namegrid->ForceRefresh();
  Connect(LABELINDS_ID_OKBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(LabelWindow::OnOkButton));
  Connect(LABELINDS_ID_CANCELBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(LabelWindow::OnCancelButton));
  Connect(LABELINDS_ID_INFERBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(LabelWindow::OnInferButton));
  Connect(LABELINDS_ID_NEWBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(LabelWindow::OnNewButton));
  Connect( wxEVT_GRID_CELL_LEFT_CLICK, wxGridEventHandler( LabelWindow::OnGridCellClick ));
  Connect( wxEVT_GRID_CELL_CHANGE, wxGridEventHandler( LabelWindow::OnGridCellChanged ));

//  Connect(LABELINDS_ID_GRIDCLICK, wxEVT_GRID_CELL_LEFT_CLICKED, wxGridEvent(
  Connect( wxEVT_SIZE, wxSizeEventHandler( LabelWindow::OnSize ));
  inferButton->SetToolTip(wxT("Infer labels based on removing all numbers from individual names"));
  newButton->SetToolTip(wxT("Generate new, random colours for all populations"));
  namegrid->SetToolTip(wxT("Set labels manually in the label column.  Choose colours for a population by clicking in the right column."));
}

void LabelWindow::OnOkButton(wxCommandEvent & event)
{
  vector<int> indexlist(inputdata->getN(),-1);
  vector<wxString> indexval;
  for(int c1=0;c1<inputdata->getN();c1++){
    bool found=false;
    for(int c2=0;c2<(int)indexval.size();c2++){
	if(namegrid->GetCellValue( c1, 1)==indexval[c2]){
	  indexlist[c1]=c2;
	  found=true;
	}
    }
    if(!found){
      indexlist[c1]=indexval.size();
      indexval.push_back(namegrid->GetCellValue( c1, 1));
    }
   // inputdata->setName(c1,namegrid->GetCellValue( c1, 1));
  }
  vector<wxColour> tcols(inputdata->getN(),wxColour(0,0,0));

  vector<int> * visorder = inputdata->getorder();
  vector<int> invvisorder=*visorder;
  vector<int> invindexlist=indexlist;
  for(int c1=0;c1<inputdata->getN();c1++){
    invvisorder[visorder->at(c1)]=c1;
  }
  for(int c1=0;c1<inputdata->getN();c1++){
    invindexlist[visorder->at(c1)]=indexlist[c1];
  }

  for(int c1=0;c1<inputdata->getN();c1++){
    //tcols[c1] = namegrid->GetCellBackgroundColour(visorder->at(c1),2);
    tcols[c1] = namegrid->GetCellBackgroundColour(invvisorder[c1],2);
  }
  inputdata->setAllLabels(indexval,invindexlist);
  finedisplay->setLabelCol( inputdata->getorder(),tcols);
  //parent->checkUseClassifyLabels(true);
  parent->Refresh();
  Close(true);
}

void LabelWindow::OnSize(wxSizeEvent & event)
{
  // vsizer->Fit(this);
  wxSize newnamesize=GetSize();
  newnamesize.y-=50;
  newnamesize.x-=10;
  namegrid->SetSize(newnamesize);
}

void LabelWindow::OnNewButton(wxCommandEvent & event)
{
  for(int c1=0;c1<inputdata->getN();c1++){
    if(inputdata->nindiv(inputdata->getorder(c1))>1) {
      namegrid->SetCellBackgroundColour(c1, 2, wxColour(255,255,255));
    }else {
      bool found=false;
      for(int c2=0;c2<c1;c2++){
	if(namegrid->GetCellValue( c1, 1)==namegrid->GetCellValue( c2, 1)){
	  namegrid->SetCellBackgroundColour(c1, 2, namegrid->GetCellBackgroundColour(c2,2));
	  found=true;
	  break;
	}
      }
      if(!found){
	  namegrid->SetCellBackgroundColour(c1, 2, wxColour(RandomInteger(0,255),RandomInteger(0,255),RandomInteger(0,255)));
      }
    }
  }
  Refresh();
}


void LabelWindow::OnInferButton(wxCommandEvent & event)
{
  for(int c1=0;c1<inputdata->getN();c1++){
    if(inputdata->nindiv(inputdata->getorder(c1))>1) {
      namegrid->SetCellValue( c1, 1, wxT("Continent"));
    }else {
      wxString tmp=namegrid->GetCellValue( c1, 0), result;
      size_t len = tmp.length();
      for ( size_t n = 0; n < len; n++ )
      {
	  if ( strchr("0123456789.-", tmp[n]) == NULL ) result += tmp[n];
      }
      namegrid->SetCellValue( c1, 1, result);
    }
  }
  OnNewButton(event);
}

void LabelWindow::OnGridCellClick(wxGridEvent &event)
{
  int row=event.GetRow();
  int col=event.GetCol();
  if(col==2 &&(row>=0) && row<inputdata->getN()){ // process click on colour
    wxColourData tcol;
    tcol.SetColour(namegrid->GetCellBackgroundColour(row,col));
    wxColourDialog tdialog(this,&tcol);

    if(tdialog.ShowModal()==wxID_OK){
      UpdateOnColourChange(row, tdialog.GetColourData().GetColour());
    }
  }else{//skip
    event.Skip();
  }
}

void LabelWindow::OnGridCellChanged(wxGridEvent &event)
{
  int row=event.GetRow();
  int col=event.GetCol();
  if(col==1) UpdateOnLabelEdit(row);
  else event.Skip();
}

void LabelWindow::UpdateOnColourChange(int row,wxColour newcolour)
{
  for(int c1=0;c1<inputdata->getN();c1++){
    if(namegrid->GetCellValue( c1, 1)==namegrid->GetCellValue( row, 1)){
      namegrid->SetCellBackgroundColour(c1,2, newcolour);
    }
  }
  Refresh();
}

void LabelWindow::UpdateOnLabelEdit(int row)
{
  bool found=false;
  for(int c1=0;c1<inputdata->getN();c1++){
    if(namegrid->GetCellValue( c1, 1)==namegrid->GetCellValue( row, 1) && c1!=row){
      namegrid->SetCellBackgroundColour(row,2,  namegrid->GetCellBackgroundColour(c1,2));
      found=true;
      break;
    }
  }
  if(!found){
    namegrid->SetCellBackgroundColour(row,2,wxColour(RandomInteger(0,255),RandomInteger(0,255),RandomInteger(0,255)));
  }
}
