
#ifndef INPUTDATA_H
#define INPUTDATA_H

#include <vector>
#include <wx/string.h>
#include <wx/wx.h>
#include <wx/filename.h>
#include <wx/thread.h>
#include <wx/progdlg.h>

#include <string>
#include <iostream>
#include <sstream>
#include <stdlib.h>
#include <float.h>
#include <fstream>
#include <algorithm>

#include "../fsxml.h"
#include "../node.h"
#include "../inf1.h"
#include "../infextract3.h"
#include "../finesfunctions.h"
#include "../data.h"
#include "../fines.h"
#include "../rng.h"

#define FSGUI_SHOW_NONE 100
#define FSGUI_SHOW_COPYMATRIX 101
#define FSGUI_SHOW_PCMMATRIX 102
#define FSGUI_SHOW_COPYAGMATRIX 103
#define FSGUI_SHOW_COPYAGMATRIXSIMPLE 104

using namespace std;
using namespace fines;

class InputData;

class wxVirtualPanel : public wxPanel
{
  public:
    wxVirtualPanel(wxWindow* parent, wxWindowID id = wxID_ANY, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize, long style = wxTAB_TRAVERSAL, const wxString& name = wxT("panel"));
    virtual void show(wxDC&  dc);
};

class InputData
{
  public:
  InputData();
  ~InputData(){gsl_rng_free(rng);};
  void importFromFile(const wxString& filename);
  void exportToFile(const wxString& filename);
  inline bool hasData(){
    if(d==NULL) return(false);
    return(true);
  };
  inline bool hasPCM(){
    if(pcmat.size()==0) return(false);
    return(true);
  };
  inline bool hasTree(){
    if(tree==NULL) return(false);
    return(true);
  };
  inline Data* getData(){return(d);};
  void printTree(){
    if(tree!=NULL) tree->printTree(&cout);
  }
  inline double getDataC(){
    if(d==NULL) return(-1);
    return(d->getCfactor());
  }
// Get names stored
  inline wxString getMetaName(){
     return(metafile);
  }
  inline wxString getCopyName(){
     return(copyfile);
  }
  inline wxString getFixedName(){
     return(fixedfile);
  }
  inline wxString getMcmcName(){
     return(mcmcfile);
  }
  inline wxString getTreeName(){
     return(treefile);
  }
// Get directories stored
  inline wxString getMetaDir(){
     return(metadir);
  }
  inline wxString getCopyDir(){
     return(copydir);
  }
  inline wxString getFixedDir(){
     return(fixeddir);
  }
  inline wxString getMcmcDir(){
     return(mcmcdir);
  }
  inline wxString getTreeDir(){
     return(treedir);
  }
// Set names stored
  inline void setMetaName(wxString in){
     metafile=in;
  }
  inline void setCopyName(wxString in){
     copyfile=in;
  }
  inline void setFixedName(wxString in){
     fixedfile=in;
  }
  inline void setMcmcName(wxString in){
     mcmcfile=in;
  }
  inline void setTreeName(wxString in){
     treefile=in;
  }
// Set directories stored
  inline void setMetaDir(wxString in){
     metadir=in;
  }
  inline void setCopyDir(wxString in){
     copydir=in;
  }
  inline void setFixedDir(wxString in){
     fixeddir=in;
  }
  inline void setMcmcDir(wxString in){
     mcmcdir=in;
  }
  inline void setTreeDir(wxString in){
     treedir=in;
  }
// Copy Status flags
  inline void setCopySkip(wxString in){
    copyskip = wxAtoi(in);
  }
  inline void setCopyX(bool in){
    copyxhead=in;
  }
  inline void setCopyY(bool in){
    copyyhead=in;
  }
  inline bool getCopyX(){
    return(copyxhead);
  }
  inline bool getCopyY(){
    return(copyyhead);
  }

  inline wxString getCopySkip(){
    wxString mystring;
    mystring << copyskip;
    return(mystring);
  }
  inline bool getUseFixed(){
    return(usefixedfile);
  }
  inline void setUseFixed(bool val){
    usefixedfile=val;
  }
  // Extract copy data

  inline double getM(long i,long j,int datavis, vector<int> *order){
    // accounts for transposing to make a row represent copies TO an individual
    // also accounts for visualisation type,
    if(i<0 || j<0|| i>=(long)getordersize() ||j>=(long)getordersize()) {cerr<<"inputdata.h:getM invalid: "<<i<<","<<j<<endl;throw(string("inputdata.h:getM invalid entry requested!"));}
    long ii=order->at(i),jj=order->at(j);
    if(datavis==FSGUI_SHOW_COPYMATRIX) {
      if(d==NULL) return(0.0);
      if(jj!=ii) {
	if(!usemod) return(d->getMatrix()->at(jj)[ii]/d->nindiv(jj)/d->nindiv(ii));
	else return(getModData(jj,ii));
//	else return(getMod(d->getMatrix()->at(jj)[ii]/d->nindiv(ii)/d->nindiv(jj),ii,false));
      }else if (d->nindiv(ii)==1) return(0);
      else if(usemod) return(getModData(ii,ii));
      else return(d->getMatrix()->at(jj)[jj]/d->nindiv(jj)/(d->nindiv(jj)-1));
  //    else return(getMod(d->getMatrix()->at(jj)[jj]/d->nindiv(jj)/(d->nindiv(jj)-1),ii,false));
    }else if(datavis==FSGUI_SHOW_PCMMATRIX){
      return(pcmat[ii][jj]);
    }else if(datavis==FSGUI_SHOW_COPYAGMATRIX){
      if(d==NULL) return(0.0);
      if(beststate==NULL) return(0.0);
      if(usemod) return(getModDataAgg(jj,ii));
      else return(popaverages[beststate->getPop(jj)][beststate->getPop(ii)]);
    }else if(datavis==FSGUI_SHOW_COPYAGMATRIXSIMPLE){ // entry is a population
     if(d==NULL) return(0.0);
      if(beststate==NULL) return(0.0);
      if(usemod) {
	if(i<0 || i>=(long)modifiedData2.size()) return(0);
	if(j<0 || j>=(long)modifiedData2[i].size()) return(0);
/*	int ii=0,jj=0;
	for(unsigned int c1=0;c1<treepoporder.size();c1++) if(treepoporder[c1]==i) ii=c1;
	for(unsigned int c1=0;c1<treepoporder.size();c1++) if(treepoporder[c1]==j) jj=c1;*/
	int ii=getPopOrder(treepoporder[i]),jj=getPopOrder(treepoporder[j]);
	int iii=getIndInPopIndexes(ii)[0];
	int jjj=getIndInPopIndexes(jj)[0];
	return(modifiedData2[jjj][iii]);
      } else {
	if(i<0 || i>=(long)popaverages.size()) return(0);
	if(j<0 || j>=(long)popaverages[i].size()) return(0);
/*	for(unsigned int c1=0;c1<treepoporder.size();c1++) if(treepoporder[c1]==i) ii=c1;
	for(unsigned int c1=0;c1<treepoporder.size();c1++) if(treepoporder[c1]==j) jj=c1;*/
	int ii=getPopOrder(treepoporder[i]),jj=getPopOrder(treepoporder[j]);
	return(popaverages[jj][ii]);
      }
    }
    return(-1);
  }
  inline double getModData(long i,long j){
    if(i<0 || i>=(int)modifiedData.size()) return(d->getMatrix()->at(i)[j]/d->nindiv(i)/d->nindiv(j));
    if(j<0 || j>=(int)modifiedData[i].size()) return(d->getMatrix()->at(i)[j]/d->nindiv(i)/d->nindiv(j));
    return(modifiedData[i][j]);
  }
  inline double getModDataAgg(long i,long j){
    if(i<0 || i>=(int)modifiedData2.size()) return(popaverages[beststate->getPop(i)][beststate->getPop(j)]);
    if(j<0 || j>=(int)modifiedData2[i].size()) return(popaverages[beststate->getPop(i)][beststate->getPop(j)]);
    return(modifiedData2[i][j]);
  }
  inline vector<vector<double> > * getdMatrix(){
    return(d->getMatrix());
  }
  inline long getPop(long i,bool useorder=false){
    int pop=-1;
    if(beststate!=NULL) pop=beststate->getPop(i);
    if(useorder)pop=invertPopOrder(pop);
    return(pop);
  }///* gets the population membership of an individual
  inline double getM(long i,long j,int datavis){
    return(getM(i,j,datavis,getorder()));
  }
  inline long getMsize(bool y,int datavis){
    if(datavis==FSGUI_SHOW_COPYMATRIX){
      if(d==NULL) return(0);
      if(!y) return(d->getMatrix()->size());
      else if(d->getMatrix()->size()==0) return(0);
      else return(d->getMatrix()->at(0).size());
    }else if(datavis==FSGUI_SHOW_PCMMATRIX){
      if(!y) return(d->getMatrix()->size());
      else if(d->getMatrix()->size()==0) return(0);
      else return(d->getMatrix()->at(0).size());
    }else if(datavis==FSGUI_SHOW_COPYAGMATRIX){
      if(d==NULL) return(0.0);
      if(!y) return(d->getMatrix()->size());
      else if(d->getMatrix()->size()==0) return(0);
      else return(d->getMatrix()->at(0).size());
    }else if(datavis==FSGUI_SHOW_COPYAGMATRIXSIMPLE){
      if(d==NULL) return(0.0);
      if(!y) return(popaverages.size());
      else if(popaverages.size()==0) return(0);
      return(popaverages[0].size());
    }return(-1);
  }// gets the matrix size in x or y directions
  inline long getN(int datavis=FSGUI_SHOW_COPYMATRIX){
     if(d==NULL) return(0);
     if(datavis==FSGUI_SHOW_COPYAGMATRIXSIMPLE) return(popaverages.size());
     return(d->getDim());
  }///* Gets the number of individuals in the data
  inline wxString getName(int i){
     if(d==NULL) return(wxT(""));
     if((int)renamed.size()==d->getN()) return(renamed[i]);
     wxString ret(d->getnames(i).c_str(), wxConvUTF8);
     return(ret);
  }///* Gets the name of individual i
  inline void setName(int c1,wxString val){
    if(c1<0 || c1>=(int)renamed.size()) return;
    renamed[c1]=val;
  }
  inline long getNumPops(){
    return(popnames.size());
  }
  inline int getPopOrder(int i){
    if(i<(int)poporder.size() && i>=0) {
      //if(i<d->numIgnore()) return(poporder[i])
      return(poporder[i]);
    }
    return(i);
  }
  inline vector<int> getPopOrder(){
    return(poporder);
  }
  inline void setPopOrder(vector<int> vec){
    poporder=vec;
  }
  inline int invertPopOrder(int i){
    if(i>=(int)poporder.size() || i<0) return(i);
    for(unsigned int c1=0;c1<poporder.size();c1++) if(poporder[c1]==i) return(c1);
    return(i);
  }
  inline int invertOrder(int i){
    vector<int> *torder=getorder();
    if(i>=(int)torder->size() || i<0) return(i);
    for(unsigned int c1=0;c1<torder->size();c1++) if(torder->at(c1)==i) return(c1);
    return(i);
  }
  inline long getPopNode(long i,bool useorder=false){
    if(i<0||i>=(long)popnodes.size()){cerr<<"Error in inputdata:getPopNode: invalid pop index requested"<<endl;throw(string("Error in inputdata:getPopNode: invalid pop index requested!"));}
    if(useorder) {
      if(getPopOrder(i)<0||getPopOrder(i)>=(long)popnodes.size()){cerr<<"Error in inputdata:getPopNode: invalid pop index:"<<getPopOrder(i)<<" requested via getpoporder"<<endl;throw(string("Error in inputdata:getPopNode: invalid pop index requested via getpoporder!"));}
      return(popnodes[getPopOrder(i)]);
    }
    return(popnodes[i]);
  }
  inline wxString getPopName(long i,bool useorder=false){
    if(i<0||i>=(long)popnames.size()){cerr<<"Error in inputdata:getPopName: invalid pop index:"<<i<<" requested"<<endl;throw(string("Error in inputdata:getPopName: invalid pop index requested!"));}
    if(useorder) {
      if(getPopOrder(i)<0||getPopOrder(i)>=(long)popnames.size()){cerr<<"Error in inputdata:getPopName: invalid pop index:"<<getPopOrder(i)<<" requested via getpoporder"<<endl;throw(string("Error in inputdata:getPopName: invalid pop index requested via getpoporder!"));}
      return(popnames[getPopOrder(i)]);
    }
    return(popnames[i]);
  }
  inline void setPopName(long i,wxString val,bool useorder=false){
    if(i<0||i>=(long)popnames.size()){cerr<<"Error in inputdata:setPopName: invalid pop index requested"<<endl;throw(string("Error in inputdata:setPopName: invalid pop index requested!"));}
    if(useorder) i=getPopOrder(i);
    popnames[i]=val;
  }
  inline vector<int> getIndInPopIndexes(long i,bool useorder=false){
     std::vector<Node*> nodes=getNodes();
     if(useorder)i=getPopOrder(i);
     if((int)nodes.size()<getPopNode(i)) return(vector<int>(0));
     return(nodes[getPopNode(i)]->tipsUnder());
  }
  inline wxString getIndsInPop(long i,bool useorder=false){
    if(i<0||i>=(long)popnames.size()){cerr<<"Error in inputdata:getPopName:"<<endl;throw(string("Error in inputdata:getPopName: invalid pop index requested!"));}
    if(useorder)i=getPopOrder(i);
    vector<int> indsin=getIndInPopIndexes(i);
    wxString ret;
    for(unsigned int c1=0;c1<indsin.size()-1;c1++) ret=ret+getName(indsin[c1])+wxT(",");
    if(indsin.size()>0) ret<<getName(indsin[indsin.size()-1]);//indsin[indsin.size()-1];
      return(ret);
  }
  void setPopOrderFromTree();///<Sets the treepoporder vector from the tree
  long insidePopNode(Node *n);///* returns the index of the popnode this node is inside, or -1 if not inside any
  bool reorderPop(int popnum,vector<int> neworder);///*reorders the tree so that the requested order is obtained.  returns true if successful
  bool reorderAll(vector<int> neworder);///* reorders the population labels
  void reorderAllDefault(bool reset=false);///< Reorders the population labels based on the tree
  bool readCopyFile();///* Reads the copyfile we've been given
  inline void unloadCopyFile(){
    if(d!=NULL) delete(d);
    d=NULL;
    renamed=vector<wxString>();
  }
  // Extract MCMC data
  bool runMCMC(wxPanel* parent=NULL);///* Runs the MCMC
  bool readPairwiseCoincidence();///* Gets the pairwise coincidence
  inline wxString getMcmcBurnin(){
    wxString mystring;
    mystring << mcmcburnin;
    return(mystring);
  }
  inline void setMcmcBurnin(wxString in){
    mcmcburnin=wxAtoi(in);
  }
  inline wxString getMcmcRuntime(){
    wxString mystring;
    mystring << mcmcrunlength;
    return(mystring);
  }
  inline void setMcmcRuntime(wxString in){
    mcmcrunlength=wxAtoi(in);
  }
  inline wxString getMcmcSkip(){
    wxString mystring;
    mystring << mcmcskip;
    return(mystring);
  }
  inline void setMcmcSkip(wxString in){
    mcmcskip=wxAtoi(in);
  }
  inline wxString getMcmcConst(){
    wxString mystring;
    mystring << mcmcconst;
    return(mystring);
  }
  inline void setMcmcConst(wxString in){
    mcmcconst=wxAtof(in);
  }
  inline void unloadMcmcFile(){
    pcmat=vector<vector <double> >();
  }
  // MCMC traces data
  bool readMCMCtraces();///* Gets the MCMC traces
  inline bool haveMCMCtraces(){
    if(populations.size()>0) return(true);
    return(false);
  }///* Checks if the MCMC traces have been read
   vector<double> * getPopHistory(){
    return(&populations);
  }
   vector<double> * getAlphaHistory(){
    return(&alpha);
  }
   vector<double> * getBetaHistory(){
    return(&beta);
  }
   vector<double> * getDeltaHistory(){
    return(&delta);
  }
   vector<double> * getFHistory(){
    return(&F);
  }
   double getPopHistoryD(int i){
    if(i>=0 && i<(int)populations.size()) return(populations[i]);
    return(-1);
  }
   double getAlphaHistoryD(int i){
    if(i>=0 && i<(int)alpha.size()) return(alpha[i]);
    return(-1);
  }
   double getBetaHistoryD(int i){
    if(i>=0 && i<(int)beta.size()) return(beta[i]);
    return(-1);
  }
   double getDeltaHistoryD(int i){
    if(i>=0 && i<(int)delta.size()) return(delta[i]);
    return(-1);
  }
   double getFHistoryD(int i){
    if(i>=0 && i<(int)F.size()) return(F[i]);
    return(-1);
  }
  // Extract Tree data
  inline wxString getTreeHillClimbSteps(){
    wxString mystring;
    mystring << treehillclimbsteps;
    return(mystring);
  }
  inline wxString getTreeTestMax(){
    wxString mystring;
    mystring << treetestmax;
    return(mystring);
  }
  inline int getTreeType(){
    return(treetype);
  }
  inline void setTreeHillClimbSteps(wxString in){
    treehillclimbsteps=wxAtoi(in);
  }
  inline void setTreeTestMax(wxString in){
    treetestmax=wxAtoi(in);
  }
  inline void setTreeType(int in){
    treetype=in;
  }
  inline void unloadTreeFile(){
    if(tree!=NULL) delete(tree);
    tree=NULL;
    order=vector<int>();
    displaylabels=vector<int>();
    popaverages=vector<vector <double> >();
  }
  bool generateTree(wxPanel* parent=NULL);///* Generates the tree using the current settings
  bool writeTree();///* writes the tree to the currently specified file
  bool writeTree(ostream *os );///* Reads the tree to a specific file
  bool readTree();///* Reads the tree from the currently specified file
  bool readTree(wxString filename);///* Reads the tree from a specific file
  void applytree();// sets the order, lefting, etc
  std::vector<Node*> getNodes(){
    if(tree==NULL) {
      return (vector<Node *>(0));
    }
    return(tree->getNodes());
  };///< access the tree
  inline vector<int> * getorder(){
    if(tree==NULL) return(&defaultorder);
    return(&order);
  }
  inline void setOrder(vector<int> val){
    order=val;
  }
  inline bool getDisplayLabel(int i){
    if(i>=0 &&i<(int)displaylabels.size()) return(displaylabels[i]);
    return(1);
  }
  inline void setDisplayLabel(int i,int val){
    if(i>=0 &&i<(int)displaylabels.size()) displaylabels[i]=val;
  }
  inline void toggleDisplayLabel(int i){
    if(i>=0 &&i<(int)displaylabels.size()) {
      if(displaylabels[i]==0) displaylabels[i]=1;
      else displaylabels[i]=0;
    }
  }
  unsigned int getordersize(){
    if(tree==NULL) return(defaultorder.size());
    return(order.size());
  }
  int getorder(int i){
    if(i<0) {cerr<<"nputdata.h:getorder: Negative index!"<<endl;throw("Inputdata.h:getorder: Negative index!");}
     if(tree==NULL && i<(int)defaultorder.size()) return(defaultorder[i]);
     else if(i>=(int)defaultorder.size()) {cerr<<"Inputdata.h:getorder: Invalid request!"<<endl;throw(string("Inputdata.h:getorder: Invalid request!"));}
     else if(i>=(int)order.size()) {cerr<<"Inputdata.h:getorder: Invalid request!"<<endl;throw(string("Inputdata.h:getorder: Invalid request!"));}
     return(order[i]);
  }
  Node* getRoot(){if(tree==NULL) return(NULL);return(tree->getRoot());};
  void calcPopBranches();
  void calcCopyAverages();

  void calcModifierRaw(double min,double max);
  void calcModifierAgg(double min,double max);
  inline void setSepContScale(bool val,double min=-1,double max=-1){
    if(d==NULL) return;
    usemod=val;
    calcModifierRaw(min,max);
    calcModifierAgg(min,max);
  }
  bool getUseMod(){
    return(usemod);
  }
  inline int getNumSuper(){
    if(d==NULL) return(0);
    return(d->numIgnore());
  }
  inline bool isSuper(long i){
    if(!hasTree()) return(false);
    if(i<d->numIgnore()) return(true);
    return(false);
  }
  inline void setContSize(double val){
    supersize=val;
    if(tree!=NULL) applytree();
  }
  inline double getContSize(){
    return(supersize);
  }
  inline wxString getContSizeWx(){
    wxString ret;
    ret<<getContSize();
    return(ret);
  }
  inline int getNumContinents(){
    return(contindex.size());
  }
  inline int nindiv(int c1){
    if(d==NULL) return(-1);
    return(d->nindiv(c1));
  }
  inline vector<int> getContIndex(){
    return(contindex);
  }///< Utility for reading/writing the order of populations
  inline void setContIndex(vector<int> val){
    contindex=val;
  }///< Utility for reading/writing the order of populations

  inline wxString getLabelWx(int c1) {
      if(c1>=(int)classificationIndex.size()) return(wxT(""));
      else if (classificationIndex[c1] >=(int) classificationLabel.size() || classificationIndex[c1]<0) return(wxT(""));
      return(classificationLabel[classificationIndex[getorder(c1)]]);
  }
  inline wxString getLabelUnorderedWx(int c1) {
    if(c1<0 || c1>= (int) classificationLabel.size()) return(wxT(""));
    return(classificationLabel[c1]);
  }
  inline int getLabel(int c1) {
      if(c1<0 || c1>=(int)classificationIndex.size()) return(-1);
      return(classificationIndex[c1]);
  }
  inline int getNumLabels() {
      return(classificationLabel.size());
  }
  inline void  setAllLabels(vector<wxString> vals,vector<int> tindex) {
     classificationLabel=vals;
     classificationIndex=tindex;
  }
  inline wxString getContRangeWx(int i,int datavis, bool isylab,wxString format){
    double tmin=0,tmax=0;
    if((datavis==FSGUI_SHOW_COPYAGMATRIX || datavis==FSGUI_SHOW_COPYAGMATRIXSIMPLE) && isylab) {tmin=contScaleAggMin[i];tmax=contScaleAggMax[i];
    }else if((datavis==FSGUI_SHOW_COPYAGMATRIX || datavis==FSGUI_SHOW_COPYAGMATRIXSIMPLE) && !isylab) {tmin=contScaleRowAggMin[i];tmax=contScaleRowAggMax[i];
    }else if(datavis==FSGUI_SHOW_COPYMATRIX && isylab) {tmin=contScaleRawMin[i];tmax=contScaleRawMax[i];
    }else if(datavis==FSGUI_SHOW_COPYMATRIX && !isylab) {tmin=contScaleRowRawMin[i];tmax=contScaleRowRawMax[i];
    }else return(wxT(""));
    //wxString tmp = wxT("(Range ") + wxString::Format(format,tmin) + wxT("-") + wxString::Format(format,tmax)+ wxT(")");
    wxString tmp = wxT("(") + wxString::Format(format,tmin) + wxT("-") + wxString::Format(format,tmax)+ wxT(")");
    //wxString tmp = wxT("(Range ") + wxString::Format(wxT("%i"),tmin) + wxT("-") + wxString::Format(wxT("%i"),tmax)+ wxT(")");
    return(tmp);
  }
  inline wxString getreaddatafilename(){
    return(readdatafilename);
  }
  vector<double> getPopSizes(double popscale=1.0);///<Returns the effective population sizes of each population

  inline void ensureCorrectScaleTree(bool newrescaletree,double newpopscale){
    if(popscale==newpopscale && rescaletree==newrescaletree){
      return;
    }
    rescaletree = newrescaletree;
    popscale = newpopscale;
    applytree();
  };///* whether the tree is rescaled

  void informNodesOfPopStatus();///< Uses the popnodes list to tell all tree nodes whether they are a root of or in a population
// wxThread stuff
  void* Entry();
/*  void OnExit() {
		Join();
  };*/
  protected:

// metafile related
  wxString metadir; // the file we import/export to
  wxString metafile; // the file we import/export to
// copy file related
  wxString copydir; // copy data directory
  wxString copyfile; // copy data file
  int copyskip;///* number of lines to skip for copying
  bool copyxhead;///* Do we have X headers?
  bool copyyhead;///* Do we have Y headers?
// fixed file related
  wxString fixeddir; // fixed data directory
  wxString fixedfile; // fixed data file
// mcmc file related
  wxString mcmcdir; // mcmc datafile
  wxString mcmcfile; // mcmc datafile
  long mcmcburnin;
  long mcmcrunlength;
  long mcmcskip;
  double mcmcconst;
  wxString readdatafilename;
// tree file related
  wxString treedir; // tree datafile
  wxString treefile; // tree datafile
  long treetestmax;///* max number of trees to search per merge
  long treehillclimbsteps;///* number of tree hillclimb steps
  int treetype;///* type of tree to generate
// other file related
  bool usefixedfile; ///* should we use super individuals from the specified fixed population file?
// Other: data read in
  Data *d;///* The raw copy data
  Data *dbackup;///* Backup of the data, for restoring from super individual creation (i.e. fixed files)
  Inf1 *tree;///* the tree
  State *beststate;///*Our best state, on which the tree is based
  vector<vector<double> > td; // a temporary data matrix
  vector<vector <double> > pcmat; ///* the pairwise coincidence matrix
  vector<vector <double> > popaverages; ///* the copy data averaged over populations
  vector<int> order;///* Order according to the tree (if present)
  vector<int> defaultorder;///* Order according to the tree (if present)
  vector<int> treepoporder;///* Order of pops according to the tree (if present)
  vector<int> poporder;///* reordering of the pops
  vector<int> popnodes;///* list of the population node ids
  vector< vector<int> > indlist;///*list of the individual IDs under a pop node (for careful reloading)
  vector<wxString > popnames;///* names assigned to populations
  vector<wxString > renamed; ///* names assigned to individuals

  vector<int> displaylabels;///* should we show each label or not?
  double supersize;///<How big superindividuals are compared to ordinary ones

  vector<double > populations; ///* observed number of populations K
  vector<double > alpha; ///* observed alpha
  vector<double > beta; ///* observed beta
  vector<double > delta; ///* observed delta
  vector<double > F; ///* observed F

  vector<double> contScaleAggMin;///* ratio of copies within main continent to each defined continent (agg data)
  vector<double> contScaleAggMax;///* ratio of scale: max/min (agg data)
  vector<double> contScaleRawMin;///* ratio of copies within main continent to each defined continent (raw data)
  vector<double> contScaleRawMax;///* ratio of scale: max/min (raw data)
  vector<double> contScaleRowAggMin;///*
  vector<double> contScaleRowAggMax;///*
  vector<double> contScaleRowRawMin;///*
  vector<double> contScaleRowRawMax;///*
  vector<vector <double> > modifiedData; ///* modified raw data rescaling continent columns
  vector<vector <double> > modifiedData2; ///* modified raw data rescaling continent columns
  bool usemod;///* Whether we use the modifier

  vector<int> contindex;///* A List of the ponodes locations of all the continents

  vector<wxString > classificationLabel; ///* list of all classification labels
  vector<int> classificationIndex; ///* classification label index assigned to individuals

  double popscale;///* the tree scale parameter (whether ignored or not)
  bool rescaletree;///* whether the tree is rescaled
};

#endif
