
#include <wx/progdlg.h>

#include "finegui.h"
#include "mainwin.h"
#include "settings_io.h"

IMPLEMENT_APP(FineGui)

using namespace std;

bool FineGui::OnInit()
{
  disabledisplay=false;
  rungui=true;
  finestructurefile=wxT("");
  copyfile=wxT("");
  mcmcfile=wxT("");
  treefile=wxT("");
  
   processArgs();
    wxString openfile;
    if(!rungui){
      return false;
    }

    FineMainWindow *mainwin = new FineMainWindow(wxT("Finestructure GUI"));

    if (copyfile.size()>0) mainwin->setCopyFile(copyfile);
    if (fixedfile.size()>0) mainwin->setFixedFile(fixedfile);
    if (mcmcfile.size()>0) mainwin->setMcmcFile(mcmcfile);
    if (treefile.size()>0) mainwin->setTreeFile(treefile);

    if (finestructurefile.size()>0){
      openfile=wxString(finestructurefile);
      cout<<"Will try to load file "<<std::string(openfile.mb_str()).c_str()<<endl;
    }
    

    SettingsIO *settings = new SettingsIO(mainwin);
    mainwin->setSettings(settings);
    if(!disabledisplay)   mainwin->setShowDisplay(true);
      
    mainwin->Show(true);

    settings->setFileName(wxT("."),openfile);
    if(openfile.size()>0){
    try{
      //settings->readTree();
    if(settings->openFileForReading()){
      if(disabledisplay)   mainwin->setShowDisplay(false);
      settings->readValues(NULL);
      settings->readValues(NULL,true);// second dataset
      vector <int> tpoporder=mainwin->getInputData()->getPopOrder();
      if(settings->shouldReadTree()) {
//	mainwin->getInputData()->setPopOrder(vector <int>());
	settings->readTree();
//	mainwin->getInputData()->applytree();
//	mainwin->getInputData()->setPopOrderFromTree();
      }
      settings->reopenFileForReading(); 
      settings->readSettings();
      settings->closeFileForReading();
      if(settings->shouldReadTree()) {// apply population order
	mainwin->getInputData()->reorderAll(tpoporder);
	mainwin->getInputData()->setPopOrderFromTree();
      }
      if(!disabledisplay)   mainwin->setShowDisplay(true);
    }
    }catch(std::string x){
      cout<<x<<endl;
      wxMessageBox(wxT("The requested file could not be opened as a finegui settings file."),wxT("Error opening file"));
    }
    }
    return true;
}


void FineGui::processArgs(){

  static const wxCmdLineEntryDesc g_cmdLineDesc [] =
  {
      { wxCMD_LINE_SWITCH, wxT("h"), wxT("help"), wxT("displays help on the command line parameters"),
	    wxCMD_LINE_VAL_NONE, wxCMD_LINE_OPTION_HELP },
      { wxCMD_LINE_SWITCH, wxT("d"), wxT("disableoutput"), wxT("disables the graphical output, for large data files") },
      {wxCMD_LINE_OPTION,wxT("c"),wxT("coinheritance"),wxT("Set (without loading) the data (coinheritance) filename")},
      {wxCMD_LINE_OPTION,wxT("F"),wxT("fixed"),wxT("Set (without loading) the fixed continent filename")},
      {wxCMD_LINE_OPTION,wxT("m"),wxT("mcmc"),wxT("Set (without loading) the fineSTRUCTURE MCMC filename")},        
      {wxCMD_LINE_OPTION,wxT("t"),wxT("tree"),wxT("Set (without loading) the fineSTRUCTURE Tree filename")},        
      {wxCMD_LINE_OPTION,wxT("f"),wxT("finestructurefile"),wxT("Load a fineSTRUCTURE settings file")},
      {wxCMD_LINE_PARAM,NULL,NULL,wxT("Load a fineSTRUCTURE settings file"),wxCMD_LINE_VAL_STRING,wxCMD_LINE_PARAM},
      { wxCMD_LINE_NONE },
  };
  wxCmdLineParser parser (g_cmdLineDesc, argc, argv);
  parser.Parse();
  if(parser.Found( wxT("h"))){
    rungui=false;
  }
  if(parser.Found( wxT("d"))){
    cout<<"Initially disabling graphical output"<<endl;
    disabledisplay=true;
  }
  parser.Found( wxT("f"),&finestructurefile);
  parser.Found( wxT("F"),&fixedfile);
  parser.Found( wxT("c"),&copyfile);
  parser.Found( wxT("m"),&mcmcfile);
  parser.Found( wxT("t"),&treefile);
  if(parser.GetParamCount()>0) finestructurefile=parser.GetParam(0);
}

