
#include "mainwin.h"
#include "chromo.xpm"

#include <wx/stdpaths.h>
#include <iostream>

#include <wx/listbox.h>
#include "wx/thread.h"
#include <wx/tokenzr.h>
#include "wx/dynarray.h"
#include "chromocombinegui.h"

ChromoCombineWindow::ChromoCombineWindow(const wxString& title)
       : wxFrame(NULL, wxID_ANY, title, wxDefaultPosition, wxSize(840, 800))
{
  #if defined(__WXMSW__)
  wxStandardPaths path;
  wxString iconloc=path.GetDataDir().Append(wxT("\\chromo.ico"));
  wxIcon icon(iconloc,wxBITMAP_TYPE_ICO);
  #else
  wxIcon icon(finegui_xpm);
  #endif
  SetIcon(icon);
  needsvalidating=true;
  ccw= new ChromoCombineWorker();
  int widthall=850;
  int width=250;
  int totheight=535;
  SetMinSize(wxSize(widthall,totheight));
  SetSize(wxSize(widthall,totheight));
  panel = new wxPanel(this,-1, wxPoint(0,0), wxSize(widthall,totheight));
  panel->SetMinSize( wxSize(widthall,totheight));

  panelLeft = new wxPanel(panel,-1, wxPoint(0,0), wxSize(width,totheight));
  panelLeft->SetMinSize( wxSize(width,totheight));
  panelCenter = new wxPanel(panel,-1, wxPoint(0,0), wxSize(width,totheight));
  panelCenter->SetMinSize( wxSize(width,totheight));
  panelRight = new wxPanel(panel,-1, wxPoint(0,0), wxSize(width,totheight));
  panelRight->SetMinSize( wxSize(width,totheight));
  panelRightBottom = new wxPanel(panelRight,-1, wxPoint(0,0), wxSize(width,60));
  panelRightBottom->SetMinSize( wxSize(width,60));
  panelRightTop = new wxPanel(panelRight,-1, wxPoint(0,0), wxSize(width,totheight-60));
  panelRightTop->SetMinSize( wxSize(width,totheight-60));

  int numLeft=5,numCenter=7,numRight=10;
  fgs = new wxFlexGridSizer(1, 4, 0, 10);
  fgsLeft = new wxFlexGridSizer(numLeft, 1, 10, 0);
  fgsCenter = new wxFlexGridSizer(numCenter, 1, 10, 0);
  fgsRight = new wxFlexGridSizer(3, 1, 10, 0);
  fgsRightTop = new wxFlexGridSizer(numRight, 1, 5, 0);
  fgsRightBottom = new wxFlexGridSizer(1, 1, 10, 0);

  fgs->AddGrowableRow(0);
  fgs->AddGrowableCol(0);

  fgs->Add(panelLeft,1,wxGROW);
  fgs->Add(panelCenter,1,wxGROW);
  fgs->Add(panelRight,1,wxGROW);

  fgsLeft->AddGrowableCol(0);
  fgsLeft->AddGrowableRow(numLeft-1);

  fgsCenter->AddGrowableRow(numCenter-1);
  fgsRight->AddGrowableRow(numRight-1);

/////////////////////////// LEFT PANEL

  fgsLeft->Add(new wxStaticText(panelLeft, -1, wxT("Input...")), 1,wxGROW);
/*  wxPanel *panelLeftA = new wxPanel(panelLeft,-1, wxPoint(0,0), wxSize(width,40));
  panelLeftA->SetMinSize( wxSize(width,40));
  fgsLeft->Add(panelLeftA);*/
  selectDirectoryButton=new wxButton(panelLeft, SELECTDIRECTORYBUTTON, wxT("1. Add guide directory"),wxDefaultPosition,wxSize(width,40));
  fgsLeft->Add(selectDirectoryButton, 1,wxGROW);


  wxFlexGridSizer *fgsSelectClear = new wxFlexGridSizer(1, 2, 0, 0);
  wxPanel *panelLeftA = new wxPanel(panelLeft,-1, wxPoint(0,0), wxSize(width,40));

  selectFilesButton=new wxButton(panelLeftA, SELECTFILESBUTTON, wxT("Add guide files"),wxDefaultPosition,wxSize(width-80,40));
  fgsSelectClear->Add(selectFilesButton, 1,wxGROW);
  clearFilesButton=new wxButton(panelLeftA, CLEARFILESBUTTON, wxT("Clear"),wxDefaultPosition,wxSize(-1,40));
  fgsSelectClear->Add(clearFilesButton, 1,wxGROW);
  fgsSelectClear->AddGrowableCol(1);
  panelLeftA->SetSizerAndFit(fgsSelectClear);
  fgsLeft->Add(panelLeftA, 1,wxGROW);

  selectDirectoryButton->SetBackgroundColour(wxColour (200, 200, 200));
  fgsLeft->Add(new wxStaticText(panelLeft, -1, wxT("Guide Files:")), 1,wxGROW);
  filesSelected= new wxListBox(panelLeft,LIST_FILES_SELECTED, wxPoint(0,40), wxSize(width,20),0,NULL,wxLB_SINGLE);
  fgsLeft->Add(filesSelected, 1,wxGROW);


/////////////////////// CENTER PANEL
  fgsCenter->Add(new wxStaticText(panelCenter, -1, wxT("Input... (continued)")), 1,wxGROW);

  validateButton=new wxButton(panelCenter, VALIDATEBUTTON, wxT("2. Create validated filelist"),wxDefaultPosition,wxSize(310,40));
  fgsCenter->Add(validateButton);
  validateButton->SetBackgroundColour(wxColour (200, 200, 200));

  wxPanel *panelCenterA = new wxPanel(panelCenter,-1, wxPoint(0,0), wxSize(width,40));
// Top  center options
  panelCenterA->SetMinSize( wxSize(width,40));
  int sizepanelCenterA=150;
  wxFlexGridSizer *fgsCenterA=new wxFlexGridSizer(1, 2, 0, 10);
  fgsCenterA->AddGrowableCol(1);
//  fgsCenterA->Add(new wxStaticText(panelCenterA, -1, wxT("Chromopainter Root")), 1,wxGROW);
//  chromopainterrootBox=new wxTextCtrl(panelCenterA, -1, wxT("outputfile."),wxDefaultPosition,wxSize(sizepanelCenterA,20));
//  fgsCenterA->Add(chromopainterrootBox, 1,wxGROW);
  fgsCenterA->Add(new wxStaticText(panelCenterA, -1, wxT("Chromopainter Ending")), 1,wxGROW);
  chromopainterendingBox=new wxTextCtrl(panelCenterA, -1, wxT(".out"),wxDefaultPosition,wxSize(sizepanelCenterA,25));
  fgsCenterA->Add(chromopainterendingBox, 1,wxGROW);

  panelCenterA->SetSizerAndFit(fgsCenterA);

  fgsCenter->Add(panelCenterA, 1,wxGROW);

// Middle  center options
  forcefileCbx = new wxCheckBox(panelCenter, FORCEFILECBX, wxT("Use force file?"));
  fgsCenter->Add(forcefileCbx, 1,wxGROW);

  panelCenterB = new wxPanel(panelCenter,-1, wxPoint(0,0), wxSize(width,40));
  panelCenterB->SetMinSize( wxSize(width,40));
  selectForceButton=new wxButton(panelCenterB, SELECTFORCEBUTTON, wxT("Choose Force File"),wxDefaultPosition,wxSize(150,25));
  forcefileBox = new wxTextCtrl(panelCenterB, -1, wxT(""),wxDefaultPosition,wxSize(150,25));
  forceoutputfileCbx = new wxCheckBox(panelCenterB, FORCEOUTPUTFILECBX, wxT("Overwrite forcefile?"));
  forceoutputfileCbx->SetValue(true);
  selectForceOutputButton=new wxButton(panelCenterB, SELECTFORCEOUTPUTBUTTON, wxT("Force Output File"),wxDefaultPosition,wxSize(150,20));
  forceoutputfileBox = new wxTextCtrl(panelCenterB, -1, wxT(""),wxDefaultPosition,wxSize(150,25));
  selectForceOutputButton->Disable();
  forceoutputfileBox->Disable();
  wxFlexGridSizer *fgsCenterB=new wxFlexGridSizer(3, 2, 0, 10);
  fgsCenterB->AddGrowableCol(1);
  fgsCenterB->Add(selectForceButton, 1,wxGROW);
  fgsCenterB->Add(forcefileBox, 1,wxGROW);
  fgsCenterB->Add(forceoutputfileCbx, 1,wxGROW);
  fgsCenterB->Add(new wxStaticText(panelCenterB, -1, wxT("")), 1,wxGROW);
  fgsCenterB->Add(selectForceOutputButton, 1,wxGROW);
  fgsCenterB->Add(forceoutputfileBox, 1,wxGROW);

  panelCenterB->SetSizerAndFit(fgsCenterB);

  fgsCenter->Add(panelCenterB);
  panelCenterB->Disable();
// valdidate button

 // Bottom middle file list
  fgsCenter->Add(new wxStaticText(panelCenter, -1, wxT("Accepted Files:")), 1,wxGROW);
  filesApproved= new wxListBox(panelCenter,LIST_FILES_APPROVED, wxPoint(0,40), wxSize(width,20));
  fgsCenter->Add(filesApproved, 1,wxGROW);

 /////////////////////// RIGHT PANEL
  fgsRight->Add(new wxStaticText(panelRight, -1, wxT("Output...")), 1,wxGROW);

  fgsRight->Add(panelRightBottom,1,wxGROW);
  fgsRight->Add(panelRightTop,1,wxGROW);

// Right, outputfile root
  wxPanel *panelRightA = new wxPanel(panelRightTop,-1, wxPoint(0,0), wxSize(width,40));
  wxFlexGridSizer *sizerRightA=new wxFlexGridSizer(1, 2, 0, 0);
  sizerRightA->AddGrowableCol(1);
  panelRightA->SetMinSize( wxSize(width,40));
  outputfileButton=new wxButton(panelRightA, OUTPUTFILEBUTTON, wxT("Output root:"),wxDefaultPosition,wxSize(105,30));
  sizerRightA->Add(outputfileButton);

//  sizerRightA->Add(new wxStaticText(panelRightA, -1, wxT("Outputfile Root:")), 1,wxGROW);
  outputfilerootBox=new wxTextCtrl(panelRightA, -1, wxT("outputfile"),wxDefaultPosition,wxSize(145,20));
  sizerRightA->Add(outputfilerootBox,1,wxGROW);
  panelRightA->SetSizerAndFit(sizerRightA);
  fgsRightTop->Add(panelRightA);

// Right, outputfile ending
  autooutputfileendingCbx = new wxCheckBox(panelRightTop, AUTOOUTPUTFILEENDING, wxT("Choose output file ending?"));
  fgsRightTop->Add(autooutputfileendingCbx, 1,wxGROW);

  panelRightB = new wxPanel(panelRightTop,-1, wxPoint(0,0), wxSize(width,40));
  panelRightB->SetMinSize( wxSize(width,40));
  wxFlexGridSizer *sizerRightB=new wxFlexGridSizer(1, 2, 0, 10);
  sizerRightB->AddGrowableCol(1);
  sizerRightB->Add(new wxStaticText(panelRightB, -1, wxT("Outputfile ending:")), 1,wxGROW);
  outputfileendingBox=new wxTextCtrl(panelRightB, -1, wxT(".out"),wxDefaultPosition,wxSize(130,25));
  sizerRightB->Add(outputfileendingBox, 1,wxGROW);
  panelRightB->SetSizerAndFit(sizerRightB);
  fgsRightTop->Add(panelRightB);
  panelRightB->Disable();

  ignorelengthsCbx = new wxCheckBox(panelRightTop, IGNORELENGTHSCBX, wxT("Ignore Lengths Matrix?"));
  fgsRightTop->Add(ignorelengthsCbx, 1,wxGROW);

  ignoremutsCbx = new wxCheckBox(panelRightTop, IGNOREMUTSCBX, wxT("Ignore Mutations Matrix?"));
  fgsRightTop->Add(ignoremutsCbx, 1,wxGROW);

  completeregionsCbx = new wxCheckBox(panelRightTop, COMPLETEREGIONSCBX, wxT("Complete datafile as region?"));
  fgsRightTop->Add(completeregionsCbx, 1,wxGROW);

  aboutButton=new wxButton(panelRightTop, ABOUTBUTTON, wxT("About"),wxDefaultPosition,wxSize(width,30));
  fgsRightTop->Add(aboutButton);
  helpButton=new wxButton(panelRightTop, HELPBUTTON, wxT("HELP"),wxDefaultPosition,wxSize(width,30));
  fgsRightTop->Add(helpButton);

  wxPanel *panelInfo = new wxPanel(panelRightTop,-1, wxPoint(0,0), wxSize(width,100));
  panelInfo->SetBackgroundColour(wxColour (200, 200, 200));
    wxFlexGridSizer *sizerInfo=new wxFlexGridSizer(5, 1, 0, 1);
  sizerInfo->AddGrowableCol(1);
  sizerInfo->SetMinSize( wxSize(width,100));
  sizerInfo->Add(new wxStaticText(panelInfo, -1, wxT("ChromoCombine GUI")), 1,wxGROW);
  sizerInfo->Add(new wxStaticText(panelInfo, -1, wxT("Step 0: Run ChromoPainter: \n\tplace results into directory.")), 1,wxGROW);
  sizerInfo->Add(new wxStaticText(panelInfo, -1, wxT("Step 1: \"Add guide directory\": \n\tselect your directory.")), 1,wxGROW);
  sizerInfo->Add(new wxStaticText(panelInfo, -1, wxT("Step 2: \"Create Validated filelist\":\n\tcheck the files look right.")), 1,wxGROW);
  sizerInfo->Add(new wxStaticText(panelInfo, -1, wxT("Step 3: \"Begin Processing\"!")), 1,wxGROW);
  sizerInfo->Add(new wxStaticText(panelInfo, -1, wxT("Step 4: Run fineSTRUCTURE on the \n\tresulting chunkcounts file.")), 1,wxGROW);
  panelInfo->SetSizerAndFit(sizerInfo);
  fgsRightTop->Add(panelInfo);

  ccw->wantlengths=!ignorelengthsCbx->GetValue();
  ccw->wantmuts=!ignoremutsCbx->GetValue();


  processButton=new wxButton(panelRightBottom, PROCESSBUTTON, wxT("3. BEGIN PROCESSING"),wxDefaultPosition,wxSize(width,60));
  fgsRightBottom->Add(processButton);
  processButton->SetBackgroundColour(wxColour (200, 200, 200));

  Connect(SELECTFILESBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ChromoCombineWindow::OnSelectFilesButton));
  Connect(SELECTDIRECTORYBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ChromoCombineWindow::OnSelectDirectoryButton));
  Connect(CLEARFILESBUTTON  , wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ChromoCombineWindow::OnClearFilesButton));
  Connect(SELECTFORCEBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ChromoCombineWindow::OnSelectForceButton));
  Connect(FORCEFILECBX, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(ChromoCombineWindow::OnForceCbx));
  Connect(FORCEOUTPUTFILECBX , wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(ChromoCombineWindow::OnForceOutputCbx));
  Connect(SELECTFORCEOUTPUTBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ChromoCombineWindow::OnSelectForceOutputButton));
  Connect(IGNORELENGTHSCBX, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(ChromoCombineWindow::OnIgnoreLengthCbx));
  Connect(COMPLETEREGIONSCBX, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(ChromoCombineWindow::OnCompleteRegionsCbx));
  Connect(IGNOREMUTSCBX, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(ChromoCombineWindow::OnIgnoreMutsCbx));
  Connect(AUTOOUTPUTFILEENDING, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(ChromoCombineWindow::OnAutoOutputCbx));
  Connect(OUTPUTFILEBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ChromoCombineWindow::OnOutputfileButton));
  Connect(VALIDATEBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ChromoCombineWindow::OnValidateButton));
  Connect(PROCESSBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ChromoCombineWindow::OnProcessButton));
  Connect(HELPBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ChromoCombineWindow::OnHelpButton));
  Connect(ABOUTBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ChromoCombineWindow::OnAboutButton));
  Connect(RUNFINISHED_EVENT, wxEVT_COMMAND_LISTBOX_SELECTED, wxCommandEventHandler(ChromoCombineWindow::onRunFinished));
  filesSelected->Connect(wxID_ANY,wxEVT_KEY_DOWN,wxKeyEventHandler(ChromoCombineWindow::OnFileChoiceKeyDown));
  filesApproved->Connect(wxID_ANY,wxEVT_KEY_DOWN,wxKeyEventHandler(ChromoCombineWindow::OnFileApprovedKeyDown));

#if wxUSE_STATUSBAR
    CreateStatusBar(1);
#endif // wxUSE_STATUSBAR

  panelRightTop->SetSizerAndFit(fgsRightTop);
  panelRightBottom->SetSizerAndFit(fgsRightBottom);
  panelLeft->SetSizerAndFit(fgsLeft);
  panelCenter->SetSizerAndFit(fgsCenter);
  panelRight->SetSizerAndFit(fgsRight);
  panel->SetSizerAndFit(fgs);
  Centre();

  filesSelected->SetToolTip(wxT("Files here will be searched for valid ChromoPainter roots. (They do not have to be correct)."));
  selectFilesButton->SetToolTip(wxT("Choose a number of FILES that have a valid ChromoPainter root.  They do not have to be unique."));
  selectDirectoryButton->SetToolTip(wxT("Add all files in a directory to be searched for a valid ChromoPainter root filename."));
  clearFilesButton->SetToolTip(wxT("Clears the input file list."));
  filesApproved->SetToolTip(wxT("The file root names that appear to be valid and will be processed."));
  chromopainterendingBox->SetToolTip(wxT("ending of the files, e.g. <root>.chunkcount<ending>. Don't forget the dot!"));
  forcefileCbx->SetToolTip(wxT("Select a \"continental forcing\" file - enter a valid file below!"));
  selectForceButton->SetToolTip(wxT("Choose a \"continental forcing\" file"));
  forcefileBox->SetToolTip(wxT("\"continental forcing\" - selected via button to the left"));
  forceoutputfileBox->SetToolTip(wxT("\"continental forcing\" output file - selected via button to the left"));
  selectForceOutputButton->SetToolTip(wxT("Choose the output \"continental forcing\" file"));
  forceoutputfileCbx->SetToolTip(wxT("If enabled, the input continental forcing file will be overwritten. Otherwise, create a new file"));
  validateButton->SetToolTip(wxT("Create the list of file roots (from the guide files) which will be used in the processing (optional)."));
  outputfilerootBox->SetToolTip(wxT("Root of the output files, e.g. <outputroot>.chunkcount<ending>"));
  autooutputfileendingCbx->SetToolTip(wxT("Use a different ending to the input file format?"));
  outputfileendingBox->SetToolTip(wxT("enter the ending for the output files here, e.g. <outputroot>.chunkcount<outputending>"));
  ignorelengthsCbx->SetToolTip(wxT("Do not process lengths (they are not needed for fineSTRUCTURE)."));
  ignoremutsCbx->SetToolTip(wxT("Do not process mutations (they are not needed for fineSTRUCTURE)."));
  completeregionsCbx->SetToolTip(wxT("Treat each datafile as a whole region for bootstrapping, instead of using internal regions (useful if there is strong linkage within a single datafile)."));
  processButton->SetToolTip(wxT("Combine files and calculate c (and validate if necessary)."));

  wxGetApp().m_frame=this;

}


void ChromoCombineWindow::OnSelectFilesButton(wxCommandEvent & event){

  wxFileDialog * openFileDialog = new wxFileDialog(this,wxT("Select Files or Directories"),wxT(""),wxT(""),wxT("*.*"),wxFD_MULTIPLE);
  if (openFileDialog->ShowModal() == wxID_OK){
    wxArrayString tpaths;
    wxArrayString tfilenames;
    openFileDialog->GetPaths(tpaths);
    openFileDialog->GetFilenames(tfilenames);
    for(unsigned int c1=0;c1<tpaths.Count();c1++) {

      filesSelected->Append(tfilenames[c1]);
      string stddir = std::string(tpaths[c1].mb_str());
      possibleinputfiles.push_back(stddir);
    }
  }
  needsvalidating=true;
}

void ChromoCombineWindow::OnSelectDirectoryButton(wxCommandEvent & event){
  ChromoCombineWorker ccwtmp;

  const wxString& dir = wxDirSelector(wxT("Choose a directory"));
  if(!dir.empty()) {
    string stddir = std::string(dir.mb_str());
    vector<string> dirvec;
    ccwtmp.getFilesFromDirectory(stddir,&dirvec);
    for(unsigned int c1=0;c1<dirvec.size();c1++) {
      wxString filewx(dirvec[c1].c_str(), wxConvUTF8);
      filesSelected->Append(filewx);
      string tmp;
/*#if defined(__WXMSW__)
	tmp.append("\\");
#else
	tmp.append("/");
#endif*/
	possibleinputfiles.push_back(tmp.append(dirvec[c1]));
    }
  }
  needsvalidating=true;
}

void ChromoCombineWindow::OnClearFilesButton(wxCommandEvent & event)
{
      filesSelected->Clear();
      possibleinputfiles.clear();
}

void ChromoCombineWindow::OnForceCbx(wxCommandEvent & event){
  if(forcefileCbx->GetValue()==true) panelCenterB->Enable();
  else panelCenterB->Disable();
}

void ChromoCombineWindow::OnSelectForceButton(wxCommandEvent & event){
  wxFileDialog * openFileDialog = new wxFileDialog(this,wxT("Select Continental forcing file"),wxT(""),wxT(""),wxT("*.*"),wxFD_OPEN | wxFD_FILE_MUST_EXIST);
  if (openFileDialog->ShowModal() == wxID_OK){
    forcefileBox->SetValue(openFileDialog->GetPath());
  }
}

void ChromoCombineWindow::OnForceOutputCbx(wxCommandEvent & event){
  if(forceoutputfileCbx->GetValue()==true) {
    selectForceOutputButton->Disable();
    forceoutputfileBox->Disable();
  }else {
    selectForceOutputButton->Enable();
    forceoutputfileBox->Enable();
  }
}

void ChromoCombineWindow::OnSelectForceOutputButton(wxCommandEvent & event){
  wxFileDialog * openFileDialog = new wxFileDialog(this,wxT("Select Output Continental forcing file"),wxT(""),wxT(""),wxT("*.*"),wxFD_SAVE);
  if (openFileDialog->ShowModal() == wxID_OK){
    forceoutputfileBox->SetValue(openFileDialog->GetPath());
  }
}

void ChromoCombineWindow::OnOutputfileButton(wxCommandEvent & event){
  wxFileDialog * openFileDialog = new wxFileDialog(this,wxT("Select Continental forcing file"),wxT(""),wxT(""),wxT("*.*"),wxFD_SAVE);
  if (openFileDialog->ShowModal() == wxID_OK){
    outputfilerootBox->SetValue(openFileDialog->GetPath());
  }
}

void ChromoCombineWindow::OnIgnoreLengthCbx(wxCommandEvent & event){
  ccw->wantlengths=!ignorelengthsCbx->GetValue();
}

void ChromoCombineWindow::OnIgnoreMutsCbx(wxCommandEvent & event){
  ccw->wantmuts=!ignoremutsCbx->GetValue();
}

void ChromoCombineWindow::OnAutoOutputCbx(wxCommandEvent & event){
  if(autooutputfileendingCbx->GetValue()==true) panelRightB->Enable();
  else panelRightB->Disable();
}

void ChromoCombineWindow::OnCompleteRegionsCbx(wxCommandEvent & event){
  ccw->completegenomes=completeregionsCbx->GetValue();  
}

void ChromoCombineWindow::OnValidateButton(wxCommandEvent & event){
  if(!validate()){
    wxMessageBox(wxT("Cannot validate. Either:\n\
    a) None of the \"Guide Files\" have the correct file format, i.e. end with your selected ending, or \n\
    b) Some of the required files (chunkcounts, regionchunkcounts, regionsquaredchunkcounts) are missing.\n\
    This could include chunklengths or mutationprobs if you have not deselected these.\n\
    Check that the chromopainter ending is correct, and that some chromopainter files are listed in \"Guide Files\"."),wxT("No valid files"));
#if wxUSE_STATUSBAR
    SetStatusText(_T("ChromoCombine has no valid files."));
#endif // wxUSE_STATUSBAR
  }
}

bool ChromoCombineWindow::validate(){
  ccw->outputfileending=std::string(chromopainterendingBox->GetValue().mb_str());
  ccw->makeEndings();
  ccw->getInterestingFiles(possibleinputfiles);
  ccw->testFilesExist();
  ccw->rationaliseInputFiles();
  filesApproved->Clear();
  for(unsigned int c1=0;c1<ccw->inputfileroot.size();c1++) {
      wxString tmp(ccw->inputfileroot[c1].c_str(), wxConvUTF8);
      filesApproved->Append(tmp);
  }
  needsvalidating=filesApproved->IsEmpty();
  return(!filesApproved->IsEmpty());
}

void ChromoCombineWindow::OnProcessButton(wxCommandEvent & event){
  if(needsvalidating) if(!validate()){
    wxMessageBox(wxT("Cannot validate. Either:\n\
    a) None of the \"Guide Files\" have the correct file format, i.e. end with your selected ending, or \n\
    b) Some of the required files (chunkcounts, regionchunkcounts, regionsquaredchunkcounts) are missing.\n\
    This could include chunklengths or mutationprobs if you have not deselected these.\n\
    Check that the chromopainter ending is correct, and that some chromopainter files are listed in \"Guide Files\"."),wxT("No valid files"));
#if wxUSE_STATUSBAR
    SetStatusText(_T("ChromoCombine has no valid files."));
#endif // wxUSE_STATUSBAR
    return;
  }
  if(! wxGetApp().isrunning ){
    process();
    setToStopMode();
  }else{
    stopModel();
    setToRunMode();
    wxMessageBox(wxT("Terminated chromocombine. Warning: outputfiles may be corrupted."));
  }
}

void ChromoCombineWindow::OnHelpButton(wxCommandEvent & event){
    wxMessageBox(wxT("This is ChromoCombine GUI, a tool for managing multiple ChromoPainter outputfiles for input into fineSTRUCTURE.\n\
    * Simple usage: Place all of your ChromoPainter output files in a directory.  Select that directory using \"Add Guide Directory\", then press \"BEGIN PROCESSING\".\n\
    * The output files will be summed over all files provided.  Where different files contain different individuals, they will be appended as necessary - only the columns need be the same.\n\
    * To first see what files will be processed, \"Create validated filelist\" first.  This will filter for ChromoPainter files, and list the file root for each only once.  (Note that ChromoPainter produces multiple output files for each run, so you will have onwe entry per ChromoPainter run).\n\
    * The \"c\" factor will be stored in the chunkcount file.\n\
    * Want to use continents? Create a \"continent forcing file\" as detailed in the fineSTRUCTURE manual, and select it here.  This will they add the correct value of \"c\" to that file, and NOT overwrite the \"c\" value in your chunkcount file.  fineSTRUCTURE will use the value of \"c\" from a force file where provided.\n\
    * Use the command line version for batch processing.\n\
    * See WWW.PAINTMYCHROMOSOMES.COM for more information."),wxT("ChromoCombine Help"));
}

void ChromoCombineWindow::OnAboutButton(wxCommandEvent & event){
    wxMessageBox(wxT("This is ChromoCombine GUI, a tool for managing multiple ChromoPainter outputfiles for input into fineSTRUCTURE.\n\
    Author: Daniel Lawson (dan.lawson@bristol.ac.uk)\n\
    Version: 0.0.1\n\
    Part of the fineSTRUCTURE/ChromoPainter package for the haplotype-based analysis of genetic variation.\n\
    See WWW.PAINTMYCHROMOSOMES.COM for more information."),wxT("About ChromoCombine"));
}

bool ChromoCombineWindow::stopModel(){
    pthread_mutex_lock( &wxGetApp().msg_mutex);
    if(wxGetApp().isrunning){
      pthread_cancel(wxGetApp().threadhandle);
      wxGetApp().isrunning=false;
    }
    ccw->clearAllData();
#if wxUSE_STATUSBAR
    SetStatusText(_T("ChromoCombine process killed."));
#endif // wxUSE_STATUSBAR
    pthread_mutex_unlock( &wxGetApp().msg_mutex);
    return(true);
}

void ChromoCombineWindow::setToRunMode(){
    panelLeft->Enable();
    panelCenter->Enable();
    panelRightTop->Enable();
    processButton->SetLabel(wxT("BEGIN PROCESSING"));
}

void ChromoCombineWindow::setToStopMode(){
    panelLeft->Disable();
    panelCenter->Disable();
    panelRightTop->Disable();
    processButton->SetLabel(wxT("CANCEL EXECUTION"));
}

void ChromoCombineWindow::setStatus(int flag){
#if wxUSE_STATUSBAR
      if(flag==2)SetStatusText(_T("ChromoCombine: completed with warnings."));
      if(flag==1)SetStatusText(_T("ChromoCombine: completed succesfully."));
      if(flag==0)SetStatusText(_T(""));
      if(flag==-1)SetStatusText(_T("ChromoCombine: ended with error."));
#endif // wxUSE_STATUSBAR
}

void ChromoCombineWindow::process(){
  ccw->clearAllData();
  ccw->outputfileending=std::string(chromopainterendingBox->GetValue().mb_str());

  ccw->outputfileroot=std::string(outputfilerootBox->GetValue().mb_str());
  if(autooutputfileendingCbx->IsChecked()){
    ccw->outputfileoutending=std::string(outputfileendingBox->GetValue().mb_str());
  }else {
    ccw->outputfileoutending=ccw->outputfileending;
  }

  if(forcefileCbx->IsChecked()){
    ccw->useforce=true;
    ccw->forcefile=std::string(forcefileBox->GetValue().mb_str());
    if(!forceoutputfileCbx->IsChecked()){
      ccw->forcefileoutput=std::string(forceoutputfileBox->GetValue().mb_str());
    }else ccw->forcefileoutput="";
  }else {
    ccw->useforce=false;
  }
  execccw=ccw;
  wxGetApp().isrunning=true;
  void *nullmessage=NULL;

  pthread_create( &(wxGetApp().threadhandle), NULL, runchromocombine, nullmessage);
#if wxUSE_STATUSBAR
    SetStatusText(_T("Running chromocombine.  This shouldn't take too long."));
#endif // wxUSE_STATUSBAR
}

void ChromoCombineWindow::onRunFinished(wxCommandEvent& evt)
{
      setToRunMode();
      setStatus(wxGetApp().rval);
      if(wxGetApp().rval<=0){
	wxString message;
	wxString messageheader=wxT("ChromoCombine Error.");
	switch(wxGetApp().rval){
	  case -1: message=wxT("Error reading some files.  Check the log.");break;
	  case -2: message=wxT("Error applying the force file.  Check the log.");break;
	  case -3: message=wxT("Error with the structure of some matrices.  Check the log.");break;
	  case -5: message=wxT("Error writing the updated force file.  Check the log.");break;
	  case 2: message=wxT("Warning: Not all individuals appear in the same number of outputfiles.  This may be a mistake; check carefully.");messageheader=wxT("ChromoCombine Warning.");break;
	  case -10: message=wxT("Some files have no rows. Check the log.");break;
	  case -11: message=wxT("Error reading chunkcounts file.");break;
	  case -12: message=wxT("Error reading regionchunkcounts file.");break;
	  case -13: message=wxT("Error reading regionsquaredchunkcounts file.");break;
	  case -14: message=wxT("Error reading chunklengths file. Try skipping it...");break;
	  case -15: message=wxT("Error reading mutationprobs file. Try skipping it...");break;
	  case -31: message=wxT("Chunkcounts matrix problem, probably with reading of files.  Check the log.");break;
	  case -32: message=wxT("Regionchunkcounts matrix problem, probably with reading of files.  Check the log.");break;
	  case -33: message=wxT("Regionsquaredchunkcounts matrix problem, probably with reading of files.  Check the log.");break;
	  case -34: message=wxT("Chunklengths matrix problem, probably with reading of files.  Check the log, or try skipping it...");break;
	  case -35: message=wxT("Mutationprobs matrix problem, probably with reading of files.  Check the log, or try skipping it...");break;

	  default: message=wxT("Unknown Error in ChromoPainter.  Check the Log.");break;
	}
	wxMessageBox(message,messageheader);
      }else if(wxGetApp().rval>1){
	wxMessageBox(wxT("ChromoCombine completed but with important warnings. Check the log."),wxT("ChromoCombine Completed with warnings."));
      }else{
	wxMessageBox(wxT("ChromoCombine completed successfully!"),wxT("ChromoCombine Successful!"));
      }
      wxGetApp().rval=0;
}

void ChromoCombineWindow::OnFileChoiceKeyDown(wxKeyEvent& event)
{
  if(event.GetKeyCode()==WXK_DELETE){
/*    cout<<" deleting!"<<endl;
    //wxArrayInt selections;
    cout<<"A"<<endl;
      int i=filesSelected->GetSelection();
    cout<<"B"<<endl;
    if(i==wxNOT_FOUND) return;
    cout<<"C"<<endl;
    int sel=filesSelected->GetSelection();
    cout<<"got selections..."<<endl;
    //for(unsigned int c1=0;c1<selections.Count();c1++){
	//cout<<"deleting "<<selections[c1]<<endl;
      cout<<"deleting "<<(int)sel<<endl;
//    }
*/
  }
//  cout<<"Key down..."<<endl;
  event.Skip();
}

void ChromoCombineWindow::OnFileApprovedKeyDown(wxKeyEvent& event)
{
//  cout<<"Approved  Key down..."<<endl;
   event.Skip();
}

